/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.jmh;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.RandomAccessFiles;
import org.apache.commons.io.file.PathUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Thread)
@Warmup(iterations=5, time=10, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=10, timeUnit=TimeUnit.SECONDS)
@Fork(value=1, jvmArgs={"-server"})
public class PathUtilsContentEqualsBenchmark {
    private static final Path bigFile1;
    private static final Path bigFile2;

    public static boolean newFileContentEquals(Path path1, Path path2) throws IOException {
        try (RandomAccessFile raf1 = RandomAccessFileMode.READ_ONLY.create(path1);){
            boolean bl;
            block12: {
                RandomAccessFile raf2 = RandomAccessFileMode.READ_ONLY.create(path2);
                try {
                    bl = RandomAccessFiles.contentEquals((RandomAccessFile)raf1, (RandomAccessFile)raf2);
                    if (raf2 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (raf2 != null) {
                        try {
                            raf2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                raf2.close();
            }
            return bl;
        }
    }

    @Benchmark
    public boolean[] testCurrent_fileContentEquals() throws IOException {
        boolean[] res = new boolean[]{PathUtils.fileContentEquals((Path)bigFile1, (Path)bigFile2)};
        return res;
    }

    @Benchmark
    public void testCurrent_fileContentEquals_Blackhole(Blackhole blackhole) throws IOException {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                blackhole.consume(PathUtils.fileContentEquals((Path)bigFile1, (Path)bigFile2));
            }
        }
    }

    @Benchmark
    public boolean[] testProposal_contentEquals() throws IOException {
        boolean[] res = new boolean[]{PathUtilsContentEqualsBenchmark.newFileContentEquals(bigFile1, bigFile2)};
        return res;
    }

    @Benchmark
    public void testProposal_contentEquals_Blackhole(Blackhole blackhole) throws IOException {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                blackhole.consume(PathUtilsContentEqualsBenchmark.newFileContentEquals(bigFile1, bigFile2));
            }
        }
    }

    static {
        try {
            bigFile1 = Files.createTempFile(PathUtilsContentEqualsBenchmark.class.getSimpleName(), "-1.bin", new FileAttribute[0]);
            bigFile2 = Files.createTempFile(PathUtilsContentEqualsBenchmark.class.getSimpleName(), "-2.bin", new FileAttribute[0]);
            int newLength = 1000000;
            byte[] bytes1 = new byte[1000000];
            Arrays.fill(bytes1, (byte)1);
            Files.write(bigFile1, bytes1, new OpenOption[0]);
            Files.copy(bigFile1, bigFile2, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

