/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import org.apache.commons.io.input.buffer.CircularByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CircularByteBufferTest {
    @Test
    public void testAddInvalidOffset() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> cbb.add(new byte[]{1, 2, 3}, -1, 3));
    }

    @Test
    public void testAddNegativeLength() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        byte[] targetBuffer = new byte[]{1, 2, 3};
        Assertions.assertThrows(IllegalArgumentException.class, () -> cbb.add(targetBuffer, 0, -1));
    }

    @Test
    public void testAddNullBuffer() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        Assertions.assertThrows(NullPointerException.class, () -> cbb.add(null, 0, 3));
    }

    @Test
    public void testAddValidData() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        int length = 3;
        cbb.add(new byte[]{3, 6, 9}, 0, 3);
        Assertions.assertEquals((int)3, (int)cbb.getCurrentNumberOfBytes());
    }

    @Test
    public void testPeekWithExcessiveLength() {
        Assertions.assertFalse((boolean)new CircularByteBuffer().peek(new byte[]{1, 3, 5, 7, 9}, 0, 6));
    }

    @Test
    public void testPeekWithInvalidOffset() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> cbb.peek(new byte[]{2, 4, 6, 8, 10}, -1, 5));
        Assertions.assertEquals((Object)"Illegal offset: -1", (Object)e.getMessage());
    }

    @Test
    public void testPeekWithNegativeLength() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> cbb.peek(new byte[]{1, 4, 3}, 0, -1));
        Assertions.assertEquals((Object)"Illegal length: -1", (Object)e.getMessage());
    }

    @Test
    public void testPeekWithValidArguments() {
        Assertions.assertFalse((boolean)new CircularByteBuffer().peek(new byte[]{5, 10, 15, 20, 25}, 0, 5));
    }
}

