/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.commons.io.input.buffer.CircularBufferInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CircularBufferInputStreamTest {
    private final Random rnd = new Random(1530960934483L);

    private byte[] newInputBuffer() {
        byte[] buffer = new byte[8192 + this.rnd.nextInt(512)];
        this.rnd.nextBytes(buffer);
        return buffer;
    }

    @Test
    public void testIO683() throws IOException {
        byte[] buffer = new byte[]{0, 1, -2, -2, -1, 4};
        try (ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
             CircularBufferInputStream cbis = new CircularBufferInputStream((InputStream)bais);){
            int b;
            int i = 0;
            while ((b = cbis.read()) != -1) {
                Assertions.assertEquals((int)(buffer[i] & 0xFF), (int)b, (String)("byte at index " + i + " should be equal"));
                ++i;
            }
            Assertions.assertEquals((int)buffer.length, (int)i, (String)"Should have read all the bytes");
        }
    }

    @Test
    public void testRandomRead() throws Exception {
        byte[] inputBuffer = this.newInputBuffer();
        byte[] bufferCopy = new byte[inputBuffer.length];
        ByteArrayInputStream bais = new ByteArrayInputStream(inputBuffer);
        CircularBufferInputStream cbis = new CircularBufferInputStream((InputStream)bais, 253);
        int offset = 0;
        byte[] readBuffer = new byte[256];
        block4: while (offset < bufferCopy.length) {
            switch (this.rnd.nextInt(2)) {
                case 0: {
                    int res = cbis.read();
                    if (res == -1) {
                        throw new IllegalStateException("Unexpected EOF at offset " + offset);
                    }
                    if (inputBuffer[offset] != (byte)res) {
                        throw new IllegalStateException("Expected " + inputBuffer[offset] + " at offset " + offset + ", got " + res);
                    }
                    ++offset;
                    continue block4;
                }
                case 1: {
                    int res = cbis.read(readBuffer, 0, this.rnd.nextInt(readBuffer.length + 1));
                    if (res == -1) {
                        throw new IllegalStateException("Unexpected EOF at offset " + offset);
                    }
                    if (res == 0) {
                        throw new IllegalStateException("Unexpected zero-byte-result at offset " + offset);
                    }
                    for (int i = 0; i < res; ++i) {
                        if (inputBuffer[offset] != readBuffer[i]) {
                            throw new IllegalStateException("Expected " + inputBuffer[offset] + " at offset " + offset + ", got " + readBuffer[i]);
                        }
                        ++offset;
                    }
                    continue block4;
                }
            }
            throw new IllegalStateException("Unexpected random choice value");
        }
        Assertions.assertTrue((boolean)true, (String)"Test finished OK");
    }
}

