/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.input.WindowsLineEndingInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WindowsLineEndingInputStreamTest {
    private String roundtrip(String msg) throws IOException {
        return this.roundtrip(msg, true);
    }

    private String roundtrip(String msg, boolean ensure) throws IOException {
        try (WindowsLineEndingInputStream lf = new WindowsLineEndingInputStream((InputStream)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence((CharSequence)msg)).setCharset(StandardCharsets.UTF_8).get(), ensure);){
            byte[] buf = new byte[100];
            int read = lf.read(buf);
            String string = new String(buf, 0, read, StandardCharsets.UTF_8);
            return string;
        }
    }

    @Test
    public void testInTheMiddleOfTheLine() throws Exception {
        Assertions.assertEquals((Object)"a\r\nbc\r\n", (Object)this.roundtrip("a\r\nbc"));
    }

    @Test
    public void testLinuxLineFeeds() throws Exception {
        String roundtrip = this.roundtrip("ab\nc", false);
        Assertions.assertEquals((Object)"ab\r\nc", (Object)roundtrip);
    }

    @Test
    public void testMalformed() throws Exception {
        Assertions.assertEquals((Object)"a\rbc", (Object)this.roundtrip("a\rbc", false));
    }

    @Test
    public void testMultipleBlankLines() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\nbc\r\n", (Object)this.roundtrip("a\r\n\r\nbc"));
    }

    @Test
    public void testRetainLineFeed() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\n", (Object)this.roundtrip("a\r\n\r\n", false));
        Assertions.assertEquals((Object)"a", (Object)this.roundtrip("a", false));
    }

    @Test
    public void testSimpleString() throws Exception {
        Assertions.assertEquals((Object)"abc\r\n", (Object)this.roundtrip("abc"));
    }

    @Test
    public void testTwoLinesAtEnd() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\n", (Object)this.roundtrip("a\r\n\r\n"));
    }
}

