/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.time.Duration;
import org.apache.commons.io.input.ProxyInputStreamTest;
import org.apache.commons.io.input.ThrottledInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThrottledInputStreamTest
extends ProxyInputStreamTest<ThrottledInputStream> {
    @Override
    protected ThrottledInputStream createFixture() throws IOException {
        return ((ThrottledInputStream.Builder)ThrottledInputStream.builder().setInputStream(this.createProxySource())).get();
    }

    @Test
    public void testCalSleepTimeMs() {
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)0L, (long)10000L, (long)1000L));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)Long.MAX_VALUE, (long)0L, (long)1000L));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)Long.MAX_VALUE, (long)-1L, (long)1000L));
        Assertions.assertEquals((long)1500L, (long)ThrottledInputStream.toSleepMillis((long)5L, (long)2L, (long)1000L));
        Assertions.assertEquals((long)500L, (long)ThrottledInputStream.toSleepMillis((long)5L, (long)2L, (long)2000L));
        Assertions.assertEquals((long)6500L, (long)ThrottledInputStream.toSleepMillis((long)15L, (long)2L, (long)1000L));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)1L, (long)2L, (long)1000L));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)2L, (long)2L, (long)2000L));
        Assertions.assertEquals((long)0L, (long)ThrottledInputStream.toSleepMillis((long)1L, (long)2L, (long)1000L));
    }

    @Override
    protected void testEos(ThrottledInputStream inputStream) {
        Assertions.assertEquals((long)3L, (long)inputStream.getByteCount());
    }

    @Test
    public void testGet() throws IOException {
        try (ThrottledInputStream inputStream = this.createFixture();){
            inputStream.read();
            Assertions.assertEquals((Object)Duration.ZERO, (Object)inputStream.getTotalSleepDuration());
        }
    }
}

