/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.TestResources;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.commons.io.input.ReversedLinesFileReaderTestParamBlockSize;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReversedLinesFileReaderTestSimple {
    @Test
    public void testFileSizeIsExactMultipleOfBlockSize() throws URISyntaxException, IOException {
        int blockSize = 10;
        File testFile20Bytes = TestResources.getFile("/test-file-20byteslength.bin");
        try (ReversedLinesFileReader reversedLinesFileReader = new ReversedLinesFileReader(testFile20Bytes, 10, StandardCharsets.ISO_8859_1.name());){
            ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("987654321", reversedLinesFileReader.readLine());
            ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("123456789", reversedLinesFileReader.readLine());
        }
    }

    @Test
    public void testLineCount() throws URISyntaxException, IOException {
        int blockSize = 10;
        File testFile20Bytes = TestResources.getFile("/test-file-20byteslength.bin");
        try (ReversedLinesFileReader reversedLinesFileReader = new ReversedLinesFileReader(testFile20Bytes, 10, StandardCharsets.ISO_8859_1.name());){
            Assertions.assertThrows(IllegalArgumentException.class, () -> reversedLinesFileReader.readLines(-1));
            Assertions.assertTrue((boolean)reversedLinesFileReader.readLines(0).isEmpty());
            List lines = reversedLinesFileReader.readLines(2);
            ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("987654321", (String)lines.get(0));
            ReversedLinesFileReaderTestParamBlockSize.assertEqualsAndNoLineBreaks("123456789", (String)lines.get(1));
            Assertions.assertTrue((boolean)reversedLinesFileReader.readLines(0).isEmpty());
            Assertions.assertTrue((boolean)reversedLinesFileReader.readLines(10000).isEmpty());
        }
    }

    @Test
    public void testToString() throws URISyntaxException, IOException {
        int blockSize = 10;
        File testFile20Bytes = TestResources.getFile("/test-file-20byteslength.bin");
        try (ReversedLinesFileReader reversedLinesFileReader = new ReversedLinesFileReader(testFile20Bytes, 10, StandardCharsets.ISO_8859_1.name());){
            Assertions.assertThrows(IllegalArgumentException.class, () -> reversedLinesFileReader.toString(-1));
            Assertions.assertTrue((boolean)reversedLinesFileReader.readLines(0).isEmpty());
            String lines = reversedLinesFileReader.toString(2);
            Assertions.assertEquals((Object)("123456789" + System.lineSeparator() + "987654321" + System.lineSeparator()), (Object)lines);
            Assertions.assertTrue((boolean)reversedLinesFileReader.toString(0).isEmpty());
            Assertions.assertTrue((boolean)reversedLinesFileReader.toString(10000).isEmpty());
        }
    }

    @Test
    public void testUnsupportedEncodingBig5() throws URISyntaxException {
        File testFileEncodingBig5 = TestResources.getFile("/test-file-empty.bin");
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> new ReversedLinesFileReader(testFileEncodingBig5, 8192, "Big5").close());
    }

    @Test
    public void testUnsupportedEncodingUTF16() throws URISyntaxException {
        File testFileEmpty = TestResources.getFile("/test-file-empty.bin");
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> new ReversedLinesFileReader(testFileEmpty, 8192, StandardCharsets.UTF_16.name()).close());
    }
}

