/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.input.RandomAccessFileInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RandomAccessFileInputStreamTest {
    private static final String DATA_FILE_NAME = "src/test/resources/org/apache/commons/io/test-file-iso8859-1.bin";
    private static final Path DATA_PATH = Paths.get("src/test/resources/org/apache/commons/io/test-file-iso8859-1.bin", new String[0]);
    private static final int DATA_FILE_LEN = 1430;

    private RandomAccessFile createRandomAccessFile() throws FileNotFoundException {
        return RandomAccessFileMode.READ_ONLY.create(DATA_FILE_NAME);
    }

    @Test
    public void testAvailable() throws IOException {
        try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(this.createRandomAccessFile(), true);){
            Assertions.assertEquals((int)1430, (int)inputStream.available());
        }
    }

    @Test
    public void testAvailableLong() throws IOException {
        try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(this.createRandomAccessFile(), true);){
            Assertions.assertEquals((long)1430L, (long)inputStream.availableLong());
        }
    }

    @Test
    public void testBuilderFile() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = ((RandomAccessFileInputStream.Builder)RandomAccessFileInputStream.builder().setFile(new File(DATA_FILE_NAME))).get();){
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            file.read();
        }
    }

    @Test
    public void testBuilderGet() {
        Assertions.assertThrows(IllegalStateException.class, () -> RandomAccessFileInputStream.builder().get());
    }

    @Test
    public void testBuilderPath() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = ((RandomAccessFileInputStream.Builder)RandomAccessFileInputStream.builder().setPath(DATA_PATH)).get();){
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            file.read();
        }
    }

    @Test
    public void testBuilderPathOpenOptions() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = ((RandomAccessFileInputStream.Builder)((RandomAccessFileInputStream.Builder)RandomAccessFileInputStream.builder().setPath(DATA_PATH)).setOpenOptions(new OpenOption[]{StandardOpenOption.READ})).get();){
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            file.read();
        }
    }

    @Test
    public void testBuilderRandomAccessFile() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = RandomAccessFileInputStream.builder().setRandomAccessFile(file).get();){
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            file.read();
        }
    }

    @Test
    public void testConstructorCloseOnCloseFalse() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(file, false);){
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            file.read();
        }
    }

    @Test
    public void testConstructorCloseOnCloseTrue() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(file, true);){
                Assertions.assertTrue((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            Assertions.assertThrows(IOException.class, file::read);
        }
    }

    @Test
    public void testConstructorRandomAccessFile() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(file);){
                Assertions.assertFalse((boolean)inputStream.isCloseOnClose());
                Assertions.assertNotEquals((int)-1, (int)inputStream.getRandomAccessFile().read());
            }
            file.read();
        }
    }

    @Test
    public void testConstructorRandomAccessFileNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new RandomAccessFileInputStream(null));
    }

    @Test
    public void testGetters() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();
             RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(file, true);){
            Assertions.assertEquals((Object)file, (Object)inputStream.getRandomAccessFile());
            Assertions.assertTrue((boolean)inputStream.isCloseOnClose());
        }
    }

    @Test
    public void testRead() throws IOException {
        try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(this.createRandomAccessFile(), true);){
            Assertions.assertEquals((int)65, (int)inputStream.read());
            Assertions.assertEquals((int)32, (int)inputStream.read());
            Assertions.assertEquals((int)84, (int)inputStream.read());
            Assertions.assertEquals((int)101, (int)inputStream.read());
            Assertions.assertEquals((int)115, (int)inputStream.read());
            Assertions.assertEquals((int)116, (int)inputStream.read());
            Assertions.assertEquals((int)32, (int)inputStream.read());
            Assertions.assertEquals((int)76, (int)inputStream.read());
            Assertions.assertEquals((int)105, (int)inputStream.read());
            Assertions.assertEquals((int)110, (int)inputStream.read());
            Assertions.assertEquals((int)101, (int)inputStream.read());
            Assertions.assertEquals((int)46, (int)inputStream.read());
            Assertions.assertEquals((int)1418, (int)inputStream.available());
            Assertions.assertEquals((long)1418L, (long)inputStream.availableLong());
        }
    }

    @Test
    public void testReadByteArray() throws IOException {
        try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(this.createRandomAccessFile(), true);){
            int dataLen = 12;
            byte[] buffer = new byte[12];
            Assertions.assertEquals((int)12, (int)inputStream.read(buffer));
            Assertions.assertArrayEquals((byte[])"A Test Line.".getBytes(StandardCharsets.ISO_8859_1), (byte[])buffer);
            Assertions.assertEquals((int)1418, (int)inputStream.available());
            Assertions.assertEquals((long)1418L, (long)inputStream.availableLong());
        }
    }

    @Test
    public void testReadByteArrayBounds() throws IOException {
        try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(this.createRandomAccessFile(), true);){
            int dataLen = 12;
            byte[] buffer = new byte[12];
            Assertions.assertEquals((int)12, (int)inputStream.read(buffer, 0, 12));
            Assertions.assertArrayEquals((byte[])"A Test Line.".getBytes(StandardCharsets.ISO_8859_1), (byte[])buffer);
            Assertions.assertEquals((int)1418, (int)inputStream.available());
            Assertions.assertEquals((long)1418L, (long)inputStream.availableLong());
        }
    }

    @Test
    public void testSkip() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();
             RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(file, false);){
            Assertions.assertEquals((long)0L, (long)inputStream.skip(-1L));
            Assertions.assertEquals((long)0L, (long)inputStream.skip(Integer.MIN_VALUE));
            Assertions.assertEquals((long)0L, (long)inputStream.skip(0L));
            Assertions.assertEquals((int)65, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)84, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)115, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)32, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)105, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)101, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)1418, (int)inputStream.available());
            Assertions.assertEquals((long)1418L, (long)inputStream.availableLong());
            Assertions.assertEquals((long)10L, (long)inputStream.skip(10L));
            Assertions.assertEquals((long)1408L, (long)inputStream.availableLong());
            long avail = inputStream.availableLong();
            Assertions.assertEquals((long)avail, (long)inputStream.skip(inputStream.availableLong()));
            Assertions.assertEquals((long)1430L, (long)file.length());
            Assertions.assertEquals((long)1430L, (long)file.getFilePointer());
            Assertions.assertEquals((long)0L, (long)inputStream.skip(1L));
            Assertions.assertEquals((long)0L, (long)inputStream.skip(1000000000000L));
        }
    }
}

