/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.input.MessageDigestInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MessageDigestInputStreamTest {
    static byte[] generateRandomByteStream(int pSize) {
        byte[] buffer = new byte[pSize];
        Random rnd = new Random();
        rnd.nextBytes(buffer);
        return buffer;
    }

    @Test
    public void testNoDefault() throws Exception {
        Assertions.assertThrows(IllegalStateException.class, () -> MessageDigestInputStream.builder().get());
        Assertions.assertThrows(NullPointerException.class, () -> ((MessageDigestInputStream.Builder)MessageDigestInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(new byte[]{1}))).get());
    }

    @Test
    public void testNormalUse() throws Exception {
        for (int i = 256; i < 8192; i *= 2) {
            byte[] buffer = MessageDigestInputStreamTest.generateRandomByteStream(i);
            byte[] expect = DigestUtils.sha512((byte[])buffer);
            try (MessageDigestInputStream messageDigestInputStream = ((MessageDigestInputStream.Builder)MessageDigestInputStream.builder().setMessageDigest("SHA-512").setInputStream((InputStream)new ByteArrayInputStream(buffer))).get();){
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])expect, (byte[])messageDigestInputStream.getMessageDigest().digest());
            }
            messageDigestInputStream = ((MessageDigestInputStream.Builder)MessageDigestInputStream.builder().setByteArray(buffer)).setMessageDigest(DigestUtils.getSha512Digest()).get();
            try {
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])expect, (byte[])messageDigestInputStream.getMessageDigest().digest());
                continue;
            }
            finally {
                if (messageDigestInputStream != null) {
                    messageDigestInputStream.close();
                }
            }
        }
    }
}

