/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.input.MessageDigestCalculatingInputStream;
import org.apache.commons.io.input.MessageDigestInputStreamTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MessageDigestCalculatingInputStreamTest {
    @Test
    public void testNormalUse() throws Exception {
        for (int i = 256; i < 8192; i *= 2) {
            byte[] buffer = MessageDigestInputStreamTest.generateRandomByteStream(i);
            MessageDigest defaultMessageDigest = MessageDigestCalculatingInputStream.getDefaultMessageDigest();
            byte[] defaultExpect = defaultMessageDigest.digest(buffer);
            try (MessageDigestCalculatingInputStream messageDigestInputStream = new MessageDigestCalculatingInputStream((InputStream)new ByteArrayInputStream(buffer));){
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])defaultExpect, (byte[])messageDigestInputStream.getMessageDigest().digest());
            }
            messageDigestInputStream = ((MessageDigestCalculatingInputStream.Builder)MessageDigestCalculatingInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(buffer))).get();
            try {
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])defaultExpect, (byte[])messageDigestInputStream.getMessageDigest().digest());
            }
            finally {
                if (messageDigestInputStream != null) {
                    messageDigestInputStream.close();
                }
            }
            messageDigestInputStream = ((MessageDigestCalculatingInputStream.Builder)MessageDigestCalculatingInputStream.builder().setByteArray(buffer)).get();
            try {
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])defaultExpect, (byte[])messageDigestInputStream.getMessageDigest().digest());
            }
            finally {
                if (messageDigestInputStream != null) {
                    messageDigestInputStream.close();
                }
            }
            byte[] sha512Expect = DigestUtils.sha512((byte[])buffer);
            MessageDigestCalculatingInputStream.Builder builder = MessageDigestCalculatingInputStream.builder();
            builder.setMessageDigest("SHA-512");
            builder.setInputStream((InputStream)new ByteArrayInputStream(buffer));
            try (MessageDigestCalculatingInputStream messageDigestInputStream = builder.get();){
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])sha512Expect, (byte[])messageDigestInputStream.getMessageDigest().digest());
            }
            builder = MessageDigestCalculatingInputStream.builder();
            builder.setMessageDigest("SHA-512");
            builder.setInputStream((InputStream)new ByteArrayInputStream(buffer));
            messageDigestInputStream = builder.get();
            try {
                messageDigestInputStream.consume();
                Assertions.assertArrayEquals((byte[])sha512Expect, (byte[])messageDigestInputStream.getMessageDigest().digest());
                continue;
            }
            finally {
                if (messageDigestInputStream != null) {
                    messageDigestInputStream.close();
                }
            }
        }
    }
}

