/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import org.apache.commons.io.input.ClosedInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClosedInputStreamTest {
    private void assertEof(ClosedInputStream cis) {
        Assertions.assertEquals((int)-1, (int)cis.read(), (String)"read()");
    }

    @Test
    public void testRead() throws Exception {
        try (ClosedInputStream cis = new ClosedInputStream();){
            this.assertEof(cis);
        }
    }

    @Test
    public void testReadArray() throws Exception {
        try (ClosedInputStream cis = new ClosedInputStream();){
            Assertions.assertEquals((int)-1, (int)cis.read(new byte[4096]));
            Assertions.assertEquals((int)-1, (int)cis.read(new byte[1]));
            Assertions.assertEquals((int)-1, (int)cis.read(new byte[0]));
        }
    }

    @Test
    public void testReadArrayIndex() throws Exception {
        try (ClosedInputStream cis = new ClosedInputStream();){
            Assertions.assertEquals((int)-1, (int)cis.read(new byte[4096], 0, 1));
            Assertions.assertEquals((int)-1, (int)cis.read(new byte[1], 0, 1));
            Assertions.assertEquals((int)-1, (int)cis.read(new byte[0], 0, 0));
        }
    }

    @Test
    public void testSingleton() throws Exception {
        try (ClosedInputStream cis = ClosedInputStream.CLOSED_INPUT_STREAM;){
            this.assertEof(cis);
        }
        cis = ClosedInputStream.INSTANCE;
        try {
            this.assertEof(cis);
        }
        finally {
            if (cis != null) {
                cis.close();
            }
        }
    }
}

