/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.apache.commons.io.TestResources;
import org.apache.commons.io.input.CharSequenceReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharSequenceReaderTest {
    private static final char NONE = (new char[1])[0];

    private void checkArray(char[] expected, char[] actual) {
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((char)expected[i], (char)actual[i], (String)("Compare[" + i + "]"));
        }
    }

    private void checkRead(Reader reader, String expected) throws IOException {
        for (int i = 0; i < expected.length(); ++i) {
            Assertions.assertEquals((char)expected.charAt(i), (char)((char)reader.read()), (String)("Read[" + i + "] of '" + expected + "'"));
        }
    }

    @Test
    public void testClose() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)"FooBar");
        this.checkRead((Reader)reader, "Foo");
        reader.close();
        this.checkRead((Reader)reader, "Foo");
        CharSequenceReader subReader = new CharSequenceReader((CharSequence)"xFooBarx", 1, 7);
        this.checkRead((Reader)subReader, "Foo");
        subReader.close();
        this.checkRead((Reader)subReader, "Foo");
    }

    @Test
    public void testConstructor() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CharSequenceReader((CharSequence)"FooBar", -1, 6), (String)"Expected exception not thrown for negative start.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CharSequenceReader((CharSequence)"FooBar", 1, 0), (String)"Expected exception not thrown for end before start.");
    }

    @Test
    public void testMark() throws IOException {
        try (CharSequenceReader reader = new CharSequenceReader((CharSequence)"FooBar");){
            this.checkRead((Reader)reader, "Foo");
            reader.mark(0);
            this.checkRead((Reader)reader, "Bar");
            reader.reset();
            this.checkRead((Reader)reader, "Bar");
            reader.close();
            this.checkRead((Reader)reader, "Foo");
            reader.reset();
            this.checkRead((Reader)reader, "Foo");
        }
        try (CharSequenceReader subReader = new CharSequenceReader((CharSequence)"xFooBarx", 1, 7);){
            this.checkRead((Reader)subReader, "Foo");
            subReader.mark(0);
            this.checkRead((Reader)subReader, "Bar");
            subReader.reset();
            this.checkRead((Reader)subReader, "Bar");
            subReader.close();
            this.checkRead((Reader)subReader, "Foo");
            subReader.reset();
            this.checkRead((Reader)subReader, "Foo");
        }
    }

    @Test
    public void testMarkSupported() throws Exception {
        try (CharSequenceReader reader = new CharSequenceReader((CharSequence)"FooBar");){
            Assertions.assertTrue((boolean)reader.markSupported());
        }
    }

    @Test
    public void testRead() throws IOException {
        String value = "Foo";
        this.testRead("Foo");
        this.testRead(new StringBuilder("Foo"));
        this.testRead(new StringBuffer("Foo"));
        this.testRead(CharBuffer.wrap("Foo"));
    }

    private void testRead(CharSequence charSequence) throws IOException {
        try (CharSequenceReader reader = new CharSequenceReader(charSequence);){
            Assertions.assertEquals((int)70, (int)reader.read());
            Assertions.assertEquals((int)111, (int)reader.read());
            Assertions.assertEquals((int)111, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
        reader = new CharSequenceReader(charSequence, 1, 5);
        try {
            Assertions.assertEquals((int)111, (int)reader.read());
            Assertions.assertEquals((int)111, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
        finally {
            reader.close();
        }
    }

    @Test
    public void testReadCharArray() throws IOException {
        String value = "FooBar";
        this.testReadCharArray("FooBar");
        this.testReadCharArray(new StringBuilder("FooBar"));
        this.testReadCharArray(new StringBuffer("FooBar"));
        this.testReadCharArray(CharBuffer.wrap("FooBar"));
    }

    private void testReadCharArray(CharSequence charSequence) throws IOException {
        char[] chars;
        try (CharSequenceReader reader = new CharSequenceReader(charSequence);){
            chars = new char[2];
            Assertions.assertEquals((int)2, (int)reader.read(chars));
            this.checkArray(new char[]{'F', 'o'}, chars);
            chars = new char[3];
            Assertions.assertEquals((int)3, (int)reader.read(chars));
            this.checkArray(new char[]{'o', 'B', 'a'}, chars);
            chars = new char[3];
            Assertions.assertEquals((int)1, (int)reader.read(chars));
            this.checkArray(new char[]{'r', NONE, NONE}, chars);
            Assertions.assertEquals((int)-1, (int)reader.read(chars));
        }
        reader = new CharSequenceReader(charSequence, 1, 5);
        try {
            chars = new char[2];
            Assertions.assertEquals((int)2, (int)reader.read(chars));
            this.checkArray(new char[]{'o', 'o'}, chars);
            chars = new char[3];
            Assertions.assertEquals((int)2, (int)reader.read(chars));
            this.checkArray(new char[]{'B', 'a', NONE}, chars);
            chars = new char[3];
            Assertions.assertEquals((int)-1, (int)reader.read(chars));
            this.checkArray(new char[]{NONE, NONE, NONE}, chars);
            Assertions.assertEquals((int)-1, (int)reader.read(chars));
        }
        finally {
            reader.close();
        }
    }

    @Test
    public void testReadCharArrayPortion() throws IOException {
        String value = "FooBar";
        this.testReadCharArrayPortion("FooBar");
        this.testReadCharArrayPortion(new StringBuilder("FooBar"));
        this.testReadCharArrayPortion(new StringBuffer("FooBar"));
        this.testReadCharArrayPortion(CharBuffer.wrap("FooBar"));
    }

    private void testReadCharArrayPortion(CharSequence charSequence) throws IOException {
        char[] chars = new char[10];
        try (CharSequenceReader reader = new CharSequenceReader(charSequence);){
            Assertions.assertEquals((int)3, (int)reader.read(chars, 3, 3));
            this.checkArray(new char[]{NONE, NONE, NONE, 'F', 'o', 'o'}, chars);
            Assertions.assertEquals((int)3, (int)reader.read(chars, 0, 3));
            this.checkArray(new char[]{'B', 'a', 'r', 'F', 'o', 'o', NONE}, chars);
            Assertions.assertEquals((int)-1, (int)reader.read(chars));
        }
        Arrays.fill(chars, NONE);
        reader = new CharSequenceReader(charSequence, 1, 5);
        try {
            Assertions.assertEquals((int)2, (int)reader.read(chars, 3, 2));
            this.checkArray(new char[]{NONE, NONE, NONE, 'o', 'o', NONE}, chars);
            Assertions.assertEquals((int)2, (int)reader.read(chars, 0, 3));
            this.checkArray(new char[]{'B', 'a', NONE, 'o', 'o', NONE}, chars);
            Assertions.assertEquals((int)-1, (int)reader.read(chars));
        }
        finally {
            reader.close();
        }
    }

    @Test
    public void testReady() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)"FooBar");
        Assertions.assertTrue((boolean)reader.ready());
        reader.skip(3L);
        Assertions.assertTrue((boolean)reader.ready());
        this.checkRead((Reader)reader, "Bar");
        Assertions.assertFalse((boolean)reader.ready());
        reader.reset();
        Assertions.assertTrue((boolean)reader.ready());
        reader.skip(2L);
        Assertions.assertTrue((boolean)reader.ready());
        reader.skip(10L);
        Assertions.assertFalse((boolean)reader.ready());
        reader.close();
        Assertions.assertTrue((boolean)reader.ready());
        reader.skip(20L);
        Assertions.assertFalse((boolean)reader.ready());
        CharSequenceReader subReader = new CharSequenceReader((CharSequence)"xFooBarx", 1, 7);
        Assertions.assertTrue((boolean)subReader.ready());
        subReader.skip(3L);
        Assertions.assertTrue((boolean)subReader.ready());
        this.checkRead((Reader)subReader, "Bar");
        Assertions.assertFalse((boolean)subReader.ready());
        subReader.reset();
        Assertions.assertTrue((boolean)subReader.ready());
        subReader.skip(2L);
        Assertions.assertTrue((boolean)subReader.ready());
        subReader.skip(10L);
        Assertions.assertFalse((boolean)subReader.ready());
        subReader.close();
        Assertions.assertTrue((boolean)subReader.ready());
        subReader.skip(20L);
        Assertions.assertFalse((boolean)subReader.ready());
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        CharSequenceReader reader;
        try (ObjectInputStream ois = new ObjectInputStream(TestResources.getInputStream("CharSequenceReader.bin"));){
            CharSequenceReader reader2 = (CharSequenceReader)ois.readObject();
            Assertions.assertEquals((int)70, (int)reader2.read());
            Assertions.assertEquals((int)111, (int)reader2.read());
            Assertions.assertEquals((int)111, (int)reader2.read());
            Assertions.assertEquals((int)66, (int)reader2.read());
            Assertions.assertEquals((int)97, (int)reader2.read());
            Assertions.assertEquals((int)114, (int)reader2.read());
            Assertions.assertEquals((int)-1, (int)reader2.read());
            Assertions.assertEquals((int)-1, (int)reader2.read());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            reader = new CharSequenceReader((CharSequence)"xFooBarx", 1, 7);
            oos.writeObject(reader);
        }
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));){
            reader = (CharSequenceReader)ois.readObject();
            Assertions.assertEquals((int)70, (int)reader.read());
            Assertions.assertEquals((int)111, (int)reader.read());
            Assertions.assertEquals((int)111, (int)reader.read());
            Assertions.assertEquals((int)66, (int)reader.read());
            Assertions.assertEquals((int)97, (int)reader.read());
            Assertions.assertEquals((int)114, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
            reader.reset();
            Assertions.assertEquals((int)70, (int)reader.read());
            Assertions.assertEquals((int)111, (int)reader.read());
            Assertions.assertEquals((int)111, (int)reader.read());
            Assertions.assertEquals((int)66, (int)reader.read());
            Assertions.assertEquals((int)97, (int)reader.read());
            Assertions.assertEquals((int)114, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testSkip() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)"FooBar");
        Assertions.assertEquals((long)3L, (long)reader.skip(3L));
        this.checkRead((Reader)reader, "Bar");
        Assertions.assertEquals((long)0L, (long)reader.skip(3L));
        reader.reset();
        Assertions.assertEquals((long)2L, (long)reader.skip(2L));
        Assertions.assertEquals((long)4L, (long)reader.skip(10L));
        Assertions.assertEquals((long)0L, (long)reader.skip(1L));
        reader.close();
        Assertions.assertEquals((long)6L, (long)reader.skip(20L));
        Assertions.assertEquals((int)-1, (int)reader.read());
        CharSequenceReader subReader = new CharSequenceReader((CharSequence)"xFooBarx", 1, 7);
        Assertions.assertEquals((long)3L, (long)subReader.skip(3L));
        this.checkRead((Reader)subReader, "Bar");
        Assertions.assertEquals((long)0L, (long)subReader.skip(3L));
        subReader.reset();
        Assertions.assertEquals((long)2L, (long)subReader.skip(2L));
        Assertions.assertEquals((long)4L, (long)subReader.skip(10L));
        Assertions.assertEquals((long)0L, (long)subReader.skip(1L));
        subReader.close();
        Assertions.assertEquals((long)6L, (long)subReader.skip(20L));
        Assertions.assertEquals((int)-1, (int)subReader.read());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"FooBar", (Object)new CharSequenceReader((CharSequence)"FooBar").toString());
        Assertions.assertEquals((Object)"FooBar", (Object)new CharSequenceReader((CharSequence)"xFooBarx", 1, 7).toString());
    }
}

