/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class BoundedInputStreamTest {
    private void compare(String message, byte[] expected, byte[] actual) {
        Assertions.assertEquals((int)expected.length, (int)actual.length, () -> message + " (array length equals check)");
        MutableInt mi = new MutableInt();
        for (int i = 0; i < expected.length; ++i) {
            mi.setValue(i);
            Assertions.assertEquals((byte)expected[i], (byte)actual[i], () -> message + " byte[" + mi + "]");
        }
    }

    @Test
    public void testBuilderGet() {
        Assertions.assertThrows(IllegalStateException.class, () -> BoundedInputStream.builder().get());
    }

    @ParameterizedTest
    @ValueSource(longs={-100L, -1L, 0L, 1L, 2L, 4L, 8L, 16L, 32L, 64L})
    public void testCounts(long startCount) throws Exception {
        int i;
        int readCount;
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        long actualStart = startCount < 0L ? 0L : startCount;
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setCount(startCount)).setMaxCount((long)helloWorld.length)).get();){
            Assertions.assertTrue((boolean)bounded.markSupported());
            Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxCount());
            Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)actualStart, (long)bounded.getCount());
            Assertions.assertEquals((long)Math.max(0L, bounded.getMaxCount() - actualStart), (long)bounded.getRemaining());
            Assertions.assertEquals((long)Math.max(0L, bounded.getMaxLength() - actualStart), (long)bounded.getRemaining());
            int readCount2 = 0;
            for (int i2 = 0; i2 < helloWorld.length; ++i2) {
                int expectedCh = bounded.getRemaining() > 0L ? helloWorld[i2] : -1;
                int actualCh = bounded.read();
                Assertions.assertEquals((int)expectedCh, (int)actualCh, (String)("limit = length byte[" + i2 + "]"));
                if (actualCh != -1) {
                    ++readCount2;
                }
                Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxCount());
                Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxLength());
                Assertions.assertEquals((long)(actualStart + (long)readCount2), (long)bounded.getCount(), (String)("i=" + i2));
                Assertions.assertEquals((long)Math.max(0L, bounded.getMaxCount() - ((long)readCount2 + actualStart)), (long)bounded.getRemaining());
                Assertions.assertEquals((long)Math.max(0L, bounded.getMaxLength() - ((long)readCount2 + actualStart)), (long)bounded.getRemaining());
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit = length end");
            Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)((long)readCount2 + actualStart), (long)bounded.getCount());
            Assertions.assertEquals((long)0L, (long)bounded.getRemaining());
            Assertions.assertEquals((int)0, (int)bounded.available());
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        int maxCountP1 = helloWorld.length + 1;
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setCount(startCount)).setMaxCount((long)maxCountP1)).get();){
            Assertions.assertTrue((boolean)bounded.markSupported());
            Assertions.assertEquals((long)maxCountP1, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)actualStart, (long)bounded.getCount());
            Assertions.assertEquals((long)Math.max(0L, bounded.getMaxCount() - actualStart), (long)bounded.getRemaining());
            Assertions.assertEquals((long)Math.max(0L, bounded.getMaxLength() - actualStart), (long)bounded.getRemaining());
            readCount = 0;
            for (i = 0; i < helloWorld.length; ++i) {
                int expectedCh = bounded.getRemaining() > 0L ? helloWorld[i] : -1;
                int actualCh = bounded.read();
                Assertions.assertEquals((int)expectedCh, (int)actualCh, (String)("limit = length byte[" + i + "]"));
                if (actualCh != -1) {
                    ++readCount;
                }
                Assertions.assertEquals((long)maxCountP1, (long)bounded.getMaxCount());
                Assertions.assertEquals((long)maxCountP1, (long)bounded.getMaxLength());
                Assertions.assertEquals((long)(actualStart + (long)readCount), (long)bounded.getCount(), (String)("i=" + i));
                Assertions.assertEquals((long)Math.max(0L, bounded.getMaxCount() - ((long)readCount + actualStart)), (long)bounded.getRemaining());
                Assertions.assertEquals((long)Math.max(0L, bounded.getMaxLength() - ((long)readCount + actualStart)), (long)bounded.getRemaining());
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit > length end");
            Assertions.assertEquals((int)0, (int)bounded.available());
            Assertions.assertEquals((long)maxCountP1, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)((long)readCount + actualStart), (long)bounded.getCount());
            Assertions.assertEquals((long)Math.max(0L, (long)maxCountP1 - bounded.getCount()), (long)bounded.getRemaining());
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)hello.length);
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            Assertions.assertEquals((long)hello.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)0L, (long)bounded.getCount());
            Assertions.assertEquals((long)bounded.getMaxLength(), (long)bounded.getRemaining());
            readCount = 0;
            for (i = 0; i < hello.length; ++i) {
                Assertions.assertEquals((int)hello[i], (int)bounded.read(), (String)("limit < length byte[" + i + "]"));
                Assertions.assertEquals((long)hello.length, (long)bounded.getMaxLength());
                Assertions.assertEquals((long)(++readCount), (long)bounded.getCount());
                Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount), (long)bounded.getRemaining());
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit < length end");
            Assertions.assertEquals((int)0, (int)bounded.available());
            Assertions.assertEquals((long)hello.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)readCount, (long)bounded.getCount());
            Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount), (long)bounded.getRemaining());
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            bounded.close();
        }
    }

    @Test
    public void testMarkReset() throws Exception {
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        int helloWorldLen = helloWorld.length;
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        byte[] world = " World".getBytes(StandardCharsets.UTF_8);
        int helloLen = hello.length;
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).get();){
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.mark(0);
            this.compare("limit = -1", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = -1", hello, IOUtils.toByteArray((InputStream)bounded, (int)helloLen));
            bounded.mark(helloWorldLen);
            this.compare("limit = -1", world, IOUtils.toByteArray((InputStream)bounded));
            bounded.reset();
            this.compare("limit = -1", world, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount(0L)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.mark(0);
            this.compare("limit = 0", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = 0", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            bounded.mark(helloWorldLen);
            this.compare("limit = 0", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)helloWorld.length)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.mark(0);
            this.compare("limit = length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = length", hello, IOUtils.toByteArray((InputStream)bounded, (int)helloLen));
            bounded.mark(helloWorldLen);
            this.compare("limit = length", world, IOUtils.toByteArray((InputStream)bounded));
            bounded.reset();
            this.compare("limit = length", world, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)(helloWorld.length + 1))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.mark(0);
            this.compare("limit > length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit > length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            bounded.reset();
            this.compare("limit > length", hello, IOUtils.toByteArray((InputStream)bounded, (int)helloLen));
            bounded.mark(helloWorldLen);
            this.compare("limit > length", world, IOUtils.toByteArray((InputStream)bounded));
            bounded.reset();
            this.compare("limit > length", world, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)(helloWorld.length - (hello.length + 1)))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.mark(0);
            this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded));
            bounded.reset();
            this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded, (int)helloLen));
            bounded.mark(helloWorldLen);
            this.compare("limit < length", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            bounded.reset();
            this.compare("limit < length", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
    }

    @Test
    public void testOnMaxLength() throws Exception {
        int i;
        int readCount;
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        final AtomicBoolean boolRef = new AtomicBoolean();
        try (BoundedInputStream bounded = new BoundedInputStream(new ByteArrayInputStream(helloWorld), helloWorld.length){

            protected void onMaxLength(long max, long readCount) {
                boolRef.set(true);
            }
        };){
            Assertions.assertTrue((boolean)bounded.markSupported());
            Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxCount());
            Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)0L, (long)bounded.getCount());
            Assertions.assertEquals((long)bounded.getMaxCount(), (long)bounded.getRemaining());
            Assertions.assertEquals((long)bounded.getMaxLength(), (long)bounded.getRemaining());
            Assertions.assertFalse((boolean)boolRef.get());
            int readCount2 = 0;
            for (int i2 = 0; i2 < helloWorld.length; ++i2) {
                Assertions.assertEquals((int)helloWorld[i2], (int)bounded.read(), (String)("limit = length byte[" + i2 + "]"));
                Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxCount());
                Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxLength());
                Assertions.assertEquals((long)(++readCount2), (long)bounded.getCount());
                Assertions.assertEquals((long)(bounded.getMaxCount() - (long)readCount2), (long)bounded.getRemaining());
                Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount2), (long)bounded.getRemaining());
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit = length end");
            Assertions.assertEquals((int)0, (int)bounded.available());
            Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)readCount2, (long)bounded.getCount());
            Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount2), (long)bounded.getRemaining());
            Assertions.assertTrue((boolean)boolRef.get());
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        boolRef.set(false);
        int length2 = helloWorld.length + 1;
        try (BoundedInputStream bounded = new BoundedInputStream(new ByteArrayInputStream(helloWorld), length2){

            protected void onMaxLength(long max, long readCount) {
                boolRef.set(true);
            }
        };){
            Assertions.assertTrue((boolean)bounded.markSupported());
            Assertions.assertEquals((long)length2, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)0L, (long)bounded.getCount());
            Assertions.assertEquals((long)bounded.getMaxLength(), (long)bounded.getRemaining());
            Assertions.assertFalse((boolean)boolRef.get());
            readCount = 0;
            for (i = 0; i < helloWorld.length; ++i) {
                Assertions.assertEquals((int)helloWorld[i], (int)bounded.read(), (String)("limit > length byte[" + i + "]"));
                Assertions.assertEquals((long)length2, (long)bounded.getMaxLength());
                Assertions.assertEquals((long)(++readCount), (long)bounded.getCount());
                Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount), (long)bounded.getRemaining());
            }
            Assertions.assertEquals((int)0, (int)bounded.available());
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit > length end");
            Assertions.assertEquals((long)length2, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)readCount, (long)bounded.getCount());
            Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount), (long)bounded.getRemaining());
            Assertions.assertFalse((boolean)boolRef.get());
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        boolRef.set(false);
        bounded = new BoundedInputStream(new ByteArrayInputStream(helloWorld), hello.length){

            protected void onMaxLength(long max, long readCount) {
                boolRef.set(true);
            }
        };
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            Assertions.assertEquals((long)hello.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)0L, (long)bounded.getCount());
            Assertions.assertEquals((long)bounded.getMaxLength(), (long)bounded.getRemaining());
            Assertions.assertFalse((boolean)boolRef.get());
            readCount = 0;
            for (i = 0; i < hello.length; ++i) {
                Assertions.assertEquals((int)hello[i], (int)bounded.read(), (String)("limit < length byte[" + i + "]"));
                Assertions.assertEquals((long)hello.length, (long)bounded.getMaxLength());
                Assertions.assertEquals((long)(++readCount), (long)bounded.getCount());
                Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount), (long)bounded.getRemaining());
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit < length end");
            Assertions.assertEquals((long)hello.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)readCount, (long)bounded.getCount());
            Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount), (long)bounded.getRemaining());
            Assertions.assertTrue((boolean)boolRef.get());
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            bounded.close();
        }
    }

    @Test
    public void testReadArray() throws Exception {
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).get();){
            Assertions.assertTrue((boolean)bounded.markSupported());
            this.compare("limit = -1", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount(0L)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            this.compare("limit = 0", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)helloWorld.length)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            this.compare("limit = length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)(helloWorld.length + 1))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            this.compare("limit > length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)(helloWorld.length - 6))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
    }

    @Test
    public void testReadSingle() throws Exception {
        int i;
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        try (BoundedInputStream bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)helloWorld.length);){
            Assertions.assertTrue((boolean)bounded.markSupported());
            for (i = 0; i < helloWorld.length; ++i) {
                Assertions.assertEquals((int)helloWorld[i], (int)bounded.read(), (String)("limit = length byte[" + i + "]"));
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit = length end");
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)(helloWorld.length + 1));
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            for (i = 0; i < helloWorld.length; ++i) {
                Assertions.assertEquals((int)helloWorld[i], (int)bounded.read(), (String)("limit > length byte[" + i + "]"));
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit > length end");
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            bounded.close();
        }
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)hello.length);
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            for (i = 0; i < hello.length; ++i) {
                Assertions.assertEquals((int)hello[i], (int)bounded.read(), (String)("limit < length byte[" + i + "]"));
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit < length end");
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            bounded.close();
        }
    }

    @Test
    public void testReset() throws Exception {
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).get();){
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = -1", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = -1", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount(0L)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = 0", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = 0", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)helloWorld.length)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)(helloWorld.length + 1))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit > length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit > length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)(helloWorld.length - 6))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
    }
}

