/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Predicate;
import org.apache.commons.io.function.IOBiConsumer;
import org.apache.commons.io.function.IOBiFunction;
import org.apache.commons.io.function.IOBinaryOperator;
import org.apache.commons.io.function.IOComparator;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOIntSupplier;
import org.apache.commons.io.function.IOLongSupplier;
import org.apache.commons.io.function.IOPredicate;
import org.apache.commons.io.function.IOQuadFunction;
import org.apache.commons.io.function.IORunnable;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.IOTriConsumer;
import org.apache.commons.io.function.IOTriFunction;
import org.apache.commons.io.function.IOUnaryOperator;

final class TestConstants {
    static final Path ABS_PATH_A = Paths.get("LICENSE.txt", new String[0]).toAbsolutePath();
    static final Path ABS_PATH_B = Paths.get("NOTICE.txt", new String[0]).toAbsolutePath();
    static IOBiConsumer<Object, Object> THROWING_IO_BI_CONSUMER = (t, u) -> TestConstants.throwIOException();
    static IOBiFunction<Object, Object, Object> THROWING_IO_BI_FUNCTION = (t, u) -> TestConstants.throwIOException();
    static IOBinaryOperator<?> THROWING_IO_BINARY_OPERATOR = (t, u) -> TestConstants.throwIOException();
    static IOComparator<Object> THROWING_IO_COMPARATOR = (t, u) -> (Integer)TestConstants.throwIOException();
    static IOConsumer<Object> THROWING_IO_CONSUMER = t -> TestConstants.throwIOException();
    static IOFunction<Object, Object> THROWING_IO_FUNCTION = t -> TestConstants.throwIOException();
    static IOIntSupplier THROWING_IO_INT_SUPPLIER = TestConstants::throwIOException;
    static IOLongSupplier THROWING_IO_LONG_SUPPLIER = TestConstants::throwIOException;
    static IOPredicate<Object> THROWING_IO_PREDICATE = t -> (Boolean)TestConstants.throwIOException();
    static IOQuadFunction<Object, Object, Object, Object, Object> THROWING_IO_QUAD_FUNCTION = (t, u, v, w) -> TestConstants.throwIOException();
    static IORunnable THROWING_IO_RUNNABLE = TestConstants::throwIOException;
    static IOSupplier<Object> THROWING_IO_SUPPLIER = TestConstants::throwIOException;
    static IOTriConsumer<Object, Object, Object> THROWING_IO_TRI_CONSUMER = (t, u, v) -> TestConstants.throwIOException();
    static IOTriFunction<Object, Object, Object, Object> THROWING_IO_TRI_FUNCTION = (t, u, v) -> TestConstants.throwIOException();
    static IOUnaryOperator<?> THROWING_IO_UNARY_OPERATOR = t -> TestConstants.throwIOException();
    static Predicate<Object> THROWING_PREDICATE = t -> {
        throw new UncheckedIOException(new IOException("Failure"));
    };

    TestConstants() {
    }

    static <T> T throwIOException() throws IOException {
        return TestConstants.throwIOException("Failure");
    }

    static <T> T throwIOException(String message) throws IOException {
        throw new IOException(message);
    }

    static <T> T throwRuntimeException(String message) {
        throw new RuntimeException(message);
    }
}

