/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.function.IOBiFunction;
import org.apache.commons.io.function.IOFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOBiFunctionTest {
    private boolean not(boolean value) throws IOException {
        return !value;
    }

    @Test
    public void testAndThenIOFunction() throws IOException {
        IOBiFunction isDirectory = Files::isDirectory;
        IOFunction not = this::not;
        Assertions.assertTrue((boolean)((Boolean)isDirectory.apply((Object)PathUtils.current(), (Object)PathUtils.EMPTY_LINK_OPTION_ARRAY)));
        IOBiFunction andThen = isDirectory.andThen(not);
        Assertions.assertFalse((boolean)((Boolean)andThen.apply((Object)PathUtils.current(), (Object)PathUtils.EMPTY_LINK_OPTION_ARRAY)));
    }

    @Test
    public void testApply() throws IOException {
        IOBiFunction isDirectory = Files::isDirectory;
        Assertions.assertTrue((boolean)((Boolean)isDirectory.apply((Object)PathUtils.current(), (Object)PathUtils.EMPTY_LINK_OPTION_ARRAY)));
    }

    @Test
    public void testApplyThrowsException() {
        IOBiFunction isDirectory = (t, u) -> {
            throw new IOException("Boom!");
        };
        Assertions.assertThrows(IOException.class, () -> isDirectory.apply((Object)PathUtils.current(), (Object)PathUtils.EMPTY_LINK_OPTION_ARRAY));
    }

    @Test
    public void testAsBiFunction() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("1", 0L);
        IOBiFunction f = (t, u) -> Files.size(PathUtils.current());
        map.computeIfPresent("1", f.asBiFunction());
        Assertions.assertNotEquals((long)0L, (Long)((Long)map.get("1")));
    }
}

