/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.AccumulatorPathVisitorTest;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.PathVisitor;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.EmptyFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PathVisitorFileFilter;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class PathUtilsVisitorTest {
    @TempDir
    File tempDirFile;

    static Stream<Arguments> testParameters() {
        return AccumulatorPathVisitorTest.testParameters();
    }

    @ParameterizedTest
    @MethodSource(value={"testParameters"})
    public void testCountEmptyFolder(Supplier<AccumulatorPathVisitor> supplier) throws IOException {
        Path tempDir = this.tempDirFile.toPath();
        CountingPathVisitor countingPathVisitor = CountingPathVisitor.withLongCounters();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)countingPathVisitor);
        Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new AndFileFilter(new IOFileFilter[]{countingFileFilter, DirectoryFileFilter.INSTANCE, EmptyFileFilter.EMPTY}));
        CounterAssertions.assertCounts(1L, 0L, 0L, countingPathVisitor.getPathCounters());
    }

    @ParameterizedTest
    @MethodSource(value={"testParameters"})
    public void testCountFolders1FileSize0(Supplier<AccumulatorPathVisitor> supplier) throws IOException {
        CountingPathVisitor countingPathVisitor = CountingPathVisitor.withLongCounters();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)countingPathVisitor);
        Files.walkFileTree(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]), (FileVisitor<? super Path>)countingFileFilter);
        CounterAssertions.assertCounts(1L, 1L, 0L, countingPathVisitor.getPathCounters());
    }

    @ParameterizedTest
    @MethodSource(value={"testParameters"})
    public void testCountFolders1FileSize1(Supplier<AccumulatorPathVisitor> supplier) throws IOException {
        CountingPathVisitor countingPathVisitor = CountingPathVisitor.withLongCounters();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)countingPathVisitor);
        Files.walkFileTree(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]), (FileVisitor<? super Path>)countingFileFilter);
        CounterAssertions.assertCounts(1L, 1L, 1L, countingPathVisitor.getPathCounters());
    }

    @ParameterizedTest
    @MethodSource(value={"testParameters"})
    public void testCountFolders2FileSize2(Supplier<AccumulatorPathVisitor> supplier) throws IOException {
        CountingPathVisitor countingPathVisitor = CountingPathVisitor.withLongCounters();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)countingPathVisitor);
        Files.walkFileTree(Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]), (FileVisitor<? super Path>)countingFileFilter);
        CounterAssertions.assertCounts(3L, 2L, 2L, countingPathVisitor.getPathCounters());
    }
}

