/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.io.build.AbstractOrigin;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractOriginTest<T, B extends AbstractOrigin<T, B>> {
    protected static final String FILE_RES_RO = "/org/apache/commons/io/test-file-20byteslength.bin";
    protected static final String FILE_NAME_RO = "src/test/resources/org/apache/commons/io/test-file-20byteslength.bin";
    protected static final String FILE_NAME_RW = "target/" + AbstractOriginTest.class.getSimpleName() + ".txt";
    protected AbstractOrigin<T, B> originRo;
    protected AbstractOrigin<T, B> originRw;

    protected AbstractOrigin<T, B> getOriginRo() {
        return Objects.requireNonNull(this.originRo, "originRo");
    }

    protected AbstractOrigin<T, B> getOriginRw() {
        return Objects.requireNonNull(this.originRw, "originRw");
    }

    protected void setOriginRo(AbstractOrigin<T, B> origin) {
        this.originRo = origin;
    }

    protected void setOriginRw(AbstractOrigin<T, B> origin) {
        this.originRw = origin;
    }

    @Test
    public void testGetByteArray() throws IOException {
        Assertions.assertArrayEquals((byte[])Files.readAllBytes(Paths.get(FILE_NAME_RO, new String[0])), (byte[])this.getOriginRo().getByteArray());
    }

    @Test
    public void testGetByteArrayAt_0_0() throws IOException {
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])this.getOriginRo().getByteArray(0L, 0));
    }

    @Test
    public void testGetByteArrayAt_0_1() throws IOException {
        Assertions.assertArrayEquals((byte[])new byte[]{49}, (byte[])this.getOriginRo().getByteArray(0L, 1));
    }

    @Test
    public void testGetByteArrayAt_1_1() throws IOException {
        Assertions.assertArrayEquals((byte[])new byte[]{50}, (byte[])this.getOriginRo().getByteArray(1L, 1));
    }

    @Test
    public void testGetCharSequence() throws IOException {
        Assertions.assertNotNull((Object)this.getOriginRo().getCharSequence(Charset.defaultCharset()));
    }

    @Test
    public void testGetFile() {
        Assertions.assertNotNull((Object)this.getOriginRo().getFile());
    }

    @Test
    public void testGetInputStream() throws IOException {
        try (InputStream inputStream = this.getOriginRo().getInputStream(new OpenOption[0]);){
            Assertions.assertNotNull((Object)inputStream);
        }
    }

    @Test
    public void testGetOutputStream() throws IOException {
        try (OutputStream output = this.getOriginRw().getOutputStream(new OpenOption[0]);){
            Assertions.assertNotNull((Object)output);
        }
    }

    @Test
    public void testGetPath() {
        Assertions.assertNotNull((Object)this.getOriginRo().getPath());
    }

    @Test
    public void testGetReader() throws IOException {
        try (Reader reader = this.getOriginRo().getReader(Charset.defaultCharset());){
            Assertions.assertNotNull((Object)reader);
        }
    }

    @Test
    public void testGetWriter() throws IOException {
        try (Writer writer = this.getOriginRw().getWriter(Charset.defaultCharset(), new OpenOption[0]);){
            Assertions.assertNotNull((Object)writer);
        }
    }

    @Test
    public void testSize() throws IOException {
        Assertions.assertEquals((long)Files.size(Paths.get(FILE_NAME_RO, new String[0])), (long)this.getOriginRo().getByteArray().length);
    }
}

