/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileUtilsWaitForTest {
    @Test
    public void testWaitFor0() {
        FileUtils.waitFor((File)FileUtils.current(), (int)0);
    }

    @Test
    public void testWaitForInterrupted() throws InterruptedException {
        AtomicBoolean wasInterrupted = new AtomicBoolean();
        CountDownLatch started = new CountDownLatch(2);
        int seconds = 10;
        Thread thread1 = new Thread(() -> {
            started.countDown();
            Assertions.assertTrue((boolean)FileUtils.waitFor((File)FileUtils.current(), (int)10));
            wasInterrupted.set(Thread.currentThread().isInterrupted());
        });
        thread1.start();
        started.countDown();
        thread1.interrupt();
        started.await();
        thread1.join();
        Assertions.assertTrue((boolean)wasInterrupted.get());
    }

    @Test
    public void testWaitForNegativeDuration() {
        FileUtils.waitFor((File)FileUtils.current(), (int)-1);
    }
}

