/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class AbstractFileUtilsDeleteDirectoryTest {
    @TempDir
    public File top;

    protected abstract boolean setupSymlink(File var1, File var2) throws Exception;

    @Test
    public void testDeleteDirectoryNullArgument() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.deleteDirectory(null));
    }

    @Test
    public void testDeleteDirWithASymlinkDir() throws Exception {
        File realOuter = new File(this.top, "realouter");
        Assertions.assertTrue((boolean)realOuter.mkdirs());
        File realInner = new File(realOuter, "realinner");
        Assertions.assertTrue((boolean)realInner.mkdirs());
        FileUtils.touch((File)new File(realInner, "file1"));
        Assertions.assertEquals((int)1, (int)realInner.list().length);
        File randomDirectory = new File(this.top, "randomDir");
        Assertions.assertTrue((boolean)randomDirectory.mkdirs());
        FileUtils.touch((File)new File(randomDirectory, "randomfile"));
        Assertions.assertEquals((int)1, (int)randomDirectory.list().length);
        File symlinkDirectory = new File(realOuter, "fakeinner");
        Assertions.assertTrue((boolean)this.setupSymlink(randomDirectory, symlinkDirectory));
        Assertions.assertEquals((int)1, (int)symlinkDirectory.list().length);
        FileUtils.deleteDirectory((File)realOuter);
        Assertions.assertEquals((int)1, (int)this.top.list().length);
        Assertions.assertEquals((int)1, (int)randomDirectory.list().length, (String)"Contents of sym link should not have been removed");
    }

    @Test
    public void testDeleteDirWithASymlinkDir2() throws Exception {
        File realOuter = new File(this.top, "realouter");
        Assertions.assertTrue((boolean)realOuter.mkdirs());
        File realInner = new File(realOuter, "realinner");
        Assertions.assertTrue((boolean)realInner.mkdirs());
        FileUtils.touch((File)new File(realInner, "file1"));
        Assertions.assertEquals((int)1, (int)realInner.list().length);
        File randomDirectory = new File(this.top, "randomDir");
        Assertions.assertTrue((boolean)randomDirectory.mkdirs());
        FileUtils.touch((File)new File(randomDirectory, "randomfile"));
        Assertions.assertEquals((int)1, (int)randomDirectory.list().length);
        File symlinkDirectory = new File(realOuter, "fakeinner");
        Files.createSymbolicLink(symlinkDirectory.toPath(), randomDirectory.toPath(), new FileAttribute[0]);
        Assertions.assertEquals((int)1, (int)symlinkDirectory.list().length);
        FileUtils.deleteDirectory((File)realOuter);
        Assertions.assertEquals((int)1, (int)this.top.list().length);
        Assertions.assertEquals((int)1, (int)randomDirectory.list().length, (String)"Contents of sym link should not have been removed");
    }

    @Test
    public void testDeleteDirWithSymlinkFile() throws Exception {
        File realOuter = new File(this.top, "realouter");
        Assertions.assertTrue((boolean)realOuter.mkdirs());
        File realInner = new File(realOuter, "realinner");
        Assertions.assertTrue((boolean)realInner.mkdirs());
        File realFile = new File(realInner, "file1");
        FileUtils.touch((File)realFile);
        Assertions.assertEquals((int)1, (int)realInner.list().length);
        File randomFile = new File(this.top, "randomfile");
        FileUtils.touch((File)randomFile);
        File symlinkFile = new File(realInner, "fakeinner");
        Assertions.assertTrue((boolean)this.setupSymlink(randomFile, symlinkFile));
        Assertions.assertEquals((int)2, (int)realInner.list().length);
        Assertions.assertEquals((int)2, (int)this.top.list().length);
        FileUtils.deleteDirectory((File)realOuter);
        Assertions.assertEquals((int)1, (int)this.top.list().length);
        Assertions.assertTrue((boolean)randomFile.exists());
        Assertions.assertFalse((boolean)symlinkFile.exists());
    }

    @Test
    public void testDeleteInvalidLinks() throws Exception {
        File aFile = new File(this.top, "realParentDirA");
        Assertions.assertTrue((boolean)aFile.mkdir());
        File bFile = new File(aFile, "realChildDirB");
        Assertions.assertTrue((boolean)bFile.mkdir());
        File cFile = new File(this.top, "realParentDirC");
        Assertions.assertTrue((boolean)cFile.mkdir());
        File dFile = new File(cFile, "realChildDirD");
        Assertions.assertTrue((boolean)dFile.mkdir());
        File linkToC = new File(bFile, "linkToC");
        Files.createSymbolicLink(linkToC.toPath(), cFile.toPath(), new FileAttribute[0]);
        File linkToB = new File(dFile, "linkToB");
        Files.createSymbolicLink(linkToB.toPath(), bFile.toPath(), new FileAttribute[0]);
        FileUtils.deleteDirectory((File)aFile);
        FileUtils.deleteDirectory((File)cFile);
        Assertions.assertEquals((int)0, (int)this.top.list().length);
    }

    @Test
    public void testDeleteParentSymlink() throws Exception {
        File realParent = new File(this.top, "realparent");
        Assertions.assertTrue((boolean)realParent.mkdirs());
        File realInner = new File(realParent, "realinner");
        Assertions.assertTrue((boolean)realInner.mkdirs());
        FileUtils.touch((File)new File(realInner, "file1"));
        Assertions.assertEquals((int)1, (int)realInner.list().length);
        File randomDirectory = new File(this.top, "randomDir");
        Assertions.assertTrue((boolean)randomDirectory.mkdirs());
        FileUtils.touch((File)new File(randomDirectory, "randomfile"));
        Assertions.assertEquals((int)1, (int)randomDirectory.list().length);
        File symlinkDirectory = new File(realParent, "fakeinner");
        Assertions.assertTrue((boolean)this.setupSymlink(randomDirectory, symlinkDirectory));
        Assertions.assertEquals((int)1, (int)symlinkDirectory.list().length);
        File symlinkParentDirectory = new File(this.top, "fakeouter");
        Assertions.assertTrue((boolean)this.setupSymlink(realParent, symlinkParentDirectory));
        FileUtils.deleteDirectory((File)symlinkParentDirectory);
        Assertions.assertEquals((int)2, (int)this.top.list().length);
        Assertions.assertEquals((int)1, (int)randomDirectory.list().length, (String)"Contents of sym link should not have been removed");
    }

    @Test
    public void testDeleteParentSymlink2() throws Exception {
        File realParent = new File(this.top, "realparent");
        Assertions.assertTrue((boolean)realParent.mkdirs());
        File realInner = new File(realParent, "realinner");
        Assertions.assertTrue((boolean)realInner.mkdirs());
        FileUtils.touch((File)new File(realInner, "file1"));
        Assertions.assertEquals((int)1, (int)realInner.list().length);
        File randomDirectory = new File(this.top, "randomDir");
        Assertions.assertTrue((boolean)randomDirectory.mkdirs());
        FileUtils.touch((File)new File(randomDirectory, "randomfile"));
        Assertions.assertEquals((int)1, (int)randomDirectory.list().length);
        File symlinkDirectory = new File(realParent, "fakeinner");
        Files.createSymbolicLink(symlinkDirectory.toPath(), randomDirectory.toPath(), new FileAttribute[0]);
        Assertions.assertEquals((int)1, (int)symlinkDirectory.list().length);
        File symlinkParentDirectory = new File(this.top, "fakeouter");
        Files.createSymbolicLink(symlinkParentDirectory.toPath(), realParent.toPath(), new FileAttribute[0]);
        FileUtils.deleteDirectory((File)symlinkParentDirectory);
        Assertions.assertEquals((int)2, (int)this.top.list().length);
        Assertions.assertEquals((int)1, (int)randomDirectory.list().length, (String)"Contents of sym link should not have been removed");
    }

    @Test
    public void testDeletesNested() throws Exception {
        File nested = new File(this.top, "nested");
        Assertions.assertTrue((boolean)nested.mkdirs());
        Assertions.assertEquals((int)1, (int)this.top.list().length);
        FileUtils.touch((File)new File(nested, "regular"));
        FileUtils.touch((File)new File(nested, ".hidden"));
        Assertions.assertEquals((int)2, (int)nested.list().length);
        FileUtils.deleteDirectory((File)nested);
        Assertions.assertEquals((int)0, (int)this.top.list().length);
    }

    @Test
    public void testDeletesRegular() throws Exception {
        File nested = new File(this.top, "nested");
        Assertions.assertTrue((boolean)nested.mkdirs());
        Assertions.assertEquals((int)1, (int)this.top.list().length);
        Assertions.assertEquals((int)0, (int)nested.list().length);
        FileUtils.deleteDirectory((File)nested);
        Assertions.assertEquals((int)0, (int)this.top.list().length);
    }
}

