/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.pngawt;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.jcodec.common.VideoEncoder;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.scale.AWTUtil;
import org.jcodec.scale.RgbToBgr;

public class PNGEncoder
extends VideoEncoder {
    private BufferedImage bi;
    private RgbToBgr rgbToBgr;

    @Override
    public VideoEncoder.EncodedFrame encodeFrame(Picture _pic, ByteBuffer _out) {
        Picture pic = _pic.cropped();
        if (this.bi == null) {
            this.bi = new BufferedImage(pic.getWidth(), pic.getHeight(), 5);
        }
        if (this.rgbToBgr == null) {
            this.rgbToBgr = new RgbToBgr();
        }
        if (pic.getColor() == ColorSpace.RGB) {
            this.rgbToBgr.transform(pic, pic);
        } else if (pic.getColor() != ColorSpace.BGR) {
            throw new IllegalArgumentException("Unsupported input color space: " + pic.getColor());
        }
        AWTUtil.toBufferedImage(pic, this.bi);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.bi, "png", baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new VideoEncoder.EncodedFrame(ByteBuffer.wrap(baos.toByteArray()), true);
    }

    @Override
    public ColorSpace[] getSupportedColorSpaces() {
        return new ColorSpace[]{ColorSpace.RGB};
    }

    @Override
    public int estimateBufferSize(Picture frame) {
        return frame.getWidth() * frame.getHeight() * 3;
    }
}

