/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ListCellBehavior;
import javafx.geometry.Orientation;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.skin.CellSkinBase;

public class ListCellSkin<T>
extends CellSkinBase<ListCell<T>> {
    private final BehaviorBase<ListCell<T>> behavior;

    public ListCellSkin(ListCell<T> listCell) {
        super(listCell);
        this.behavior = new ListCellBehavior<T>(listCell);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        double d6 = super.computePrefWidth(d, d2, d3, d4, d5);
        ListView listView = ((ListCell)this.getSkinnable()).getListView();
        return listView == null ? 0.0 : (listView.getOrientation() == Orientation.VERTICAL ? d6 : Math.max(d6, this.getCellSize()));
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        double d6 = this.getFixedCellSize();
        if (d6 > 0.0) {
            return d6;
        }
        double d7 = this.getCellSize();
        double d8 = d7 == 24.0 ? super.computePrefHeight(d, d2, d3, d4, d5) : d7;
        return d8;
    }

    @Override
    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        double d6 = this.getFixedCellSize();
        if (d6 > 0.0) {
            return d6;
        }
        return super.computeMinHeight(d, d2, d3, d4, d5);
    }

    @Override
    protected double computeMaxHeight(double d, double d2, double d3, double d4, double d5) {
        double d6 = this.getFixedCellSize();
        if (d6 > 0.0) {
            return d6;
        }
        return super.computeMaxHeight(d, d2, d3, d4, d5);
    }

    private double getFixedCellSize() {
        ListView listView = ((ListCell)this.getSkinnable()).getListView();
        return listView != null ? listView.getFixedCellSize() : -1.0;
    }
}

