package org.openqa.selenium.devtools.v138.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Information about a signed exchange response.
 */
@org.openqa.selenium.Beta()
public class SignedExchangeInfo {

    private final org.openqa.selenium.devtools.v138.network.model.Response outerResponse;

    private final java.util.Optional<org.openqa.selenium.devtools.v138.network.model.SignedExchangeHeader> header;

    private final java.util.Optional<org.openqa.selenium.devtools.v138.network.model.SecurityDetails> securityDetails;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v138.network.model.SignedExchangeError>> errors;

    public SignedExchangeInfo(org.openqa.selenium.devtools.v138.network.model.Response outerResponse, java.util.Optional<org.openqa.selenium.devtools.v138.network.model.SignedExchangeHeader> header, java.util.Optional<org.openqa.selenium.devtools.v138.network.model.SecurityDetails> securityDetails, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v138.network.model.SignedExchangeError>> errors) {
        this.outerResponse = java.util.Objects.requireNonNull(outerResponse, "outerResponse is required");
        this.header = header;
        this.securityDetails = securityDetails;
        this.errors = errors;
    }

    /**
     * The outer response of signed HTTP exchange which was received from network.
     */
    public org.openqa.selenium.devtools.v138.network.model.Response getOuterResponse() {
        return outerResponse;
    }

    /**
     * Information about the signed exchange header.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v138.network.model.SignedExchangeHeader> getHeader() {
        return header;
    }

    /**
     * Security details for the signed exchange header.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v138.network.model.SecurityDetails> getSecurityDetails() {
        return securityDetails;
    }

    /**
     * Errors occurred while handling the signed exchange.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v138.network.model.SignedExchangeError>> getErrors() {
        return errors;
    }

    private static SignedExchangeInfo fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v138.network.model.Response outerResponse = null;
        java.util.Optional<org.openqa.selenium.devtools.v138.network.model.SignedExchangeHeader> header = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v138.network.model.SecurityDetails> securityDetails = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v138.network.model.SignedExchangeError>> errors = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "outerResponse":
                    outerResponse = input.read(org.openqa.selenium.devtools.v138.network.model.Response.class);
                    break;
                case "header":
                    header = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v138.network.model.SignedExchangeHeader.class));
                    break;
                case "securityDetails":
                    securityDetails = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v138.network.model.SecurityDetails.class));
                    break;
                case "errors":
                    errors = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v138.network.model.SignedExchangeError.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SignedExchangeInfo(outerResponse, header, securityDetails, errors);
    }
}
