package org.openqa.selenium.devtools.v136.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Represents the source scheme of the origin that originally set the cookie.
 * A value of "Unset" allows protocol clients to emulate legacy cookie scope for the scheme.
 * This is a temporary ability and it will be removed in the future.
 */
@org.openqa.selenium.Beta()
public enum CookieSourceScheme {

    UNSET("Unset"), NONSECURE("NonSecure"), SECURE("Secure");

    private String value;

    CookieSourceScheme(String value) {
        this.value = value;
    }

    public static CookieSourceScheme fromString(String s) {
        return java.util.Arrays.stream(CookieSourceScheme.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CookieSourceScheme "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CookieSourceScheme fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
