package org.openqa.selenium.devtools.v136.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS function at-rule representation.
 */
public class CSSFunctionRule {

    private final org.openqa.selenium.devtools.v136.css.model.Value name;

    private final java.util.Optional<org.openqa.selenium.devtools.v136.css.model.StyleSheetId> styleSheetId;

    private final org.openqa.selenium.devtools.v136.css.model.StyleSheetOrigin origin;

    private final java.util.List<org.openqa.selenium.devtools.v136.css.model.CSSFunctionParameter> parameters;

    private final java.util.List<org.openqa.selenium.devtools.v136.css.model.CSSFunctionNode> children;

    public CSSFunctionRule(org.openqa.selenium.devtools.v136.css.model.Value name, java.util.Optional<org.openqa.selenium.devtools.v136.css.model.StyleSheetId> styleSheetId, org.openqa.selenium.devtools.v136.css.model.StyleSheetOrigin origin, java.util.List<org.openqa.selenium.devtools.v136.css.model.CSSFunctionParameter> parameters, java.util.List<org.openqa.selenium.devtools.v136.css.model.CSSFunctionNode> children) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.styleSheetId = styleSheetId;
        this.origin = java.util.Objects.requireNonNull(origin, "origin is required");
        this.parameters = java.util.Objects.requireNonNull(parameters, "parameters is required");
        this.children = java.util.Objects.requireNonNull(children, "children is required");
    }

    /**
     * Name of the function.
     */
    public org.openqa.selenium.devtools.v136.css.model.Value getName() {
        return name;
    }

    /**
     * The css style sheet identifier (absent for user agent stylesheet and user-specified
     * stylesheet rules) this rule came from.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v136.css.model.StyleSheetId> getStyleSheetId() {
        return styleSheetId;
    }

    /**
     * Parent stylesheet's origin.
     */
    public org.openqa.selenium.devtools.v136.css.model.StyleSheetOrigin getOrigin() {
        return origin;
    }

    /**
     * List of parameters.
     */
    public java.util.List<org.openqa.selenium.devtools.v136.css.model.CSSFunctionParameter> getParameters() {
        return parameters;
    }

    /**
     * Function body.
     */
    public java.util.List<org.openqa.selenium.devtools.v136.css.model.CSSFunctionNode> getChildren() {
        return children;
    }

    private static CSSFunctionRule fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v136.css.model.Value name = null;
        java.util.Optional<org.openqa.selenium.devtools.v136.css.model.StyleSheetId> styleSheetId = java.util.Optional.empty();
        org.openqa.selenium.devtools.v136.css.model.StyleSheetOrigin origin = null;
        java.util.List<org.openqa.selenium.devtools.v136.css.model.CSSFunctionParameter> parameters = null;
        java.util.List<org.openqa.selenium.devtools.v136.css.model.CSSFunctionNode> children = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.read(org.openqa.selenium.devtools.v136.css.model.Value.class);
                    break;
                case "styleSheetId":
                    styleSheetId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v136.css.model.StyleSheetId.class));
                    break;
                case "origin":
                    origin = input.read(org.openqa.selenium.devtools.v136.css.model.StyleSheetOrigin.class);
                    break;
                case "parameters":
                    parameters = input.readArray(org.openqa.selenium.devtools.v136.css.model.CSSFunctionParameter.class);
                    break;
                case "children":
                    children = input.readArray(org.openqa.selenium.devtools.v136.css.model.CSSFunctionNode.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSFunctionRule(name, styleSheetId, origin, parameters, children);
    }
}
