/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.dnn;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfInt;
import org.opencv.core.Scalar;
import org.opencv.dnn.DictValue;
import org.opencv.dnn.Layer;
import org.opencv.utils.Converters;

public class Net {
    protected final long nativeObj;

    protected Net(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Net __fromPtr__(long addr) {
        return new Net(addr);
    }

    public Net() {
        this.nativeObj = Net.Net_0();
    }

    public static Net readFromModelOptimizer(String xml, String bin) {
        return new Net(Net.readFromModelOptimizer_0(xml, bin));
    }

    public static Net readFromModelOptimizer(MatOfByte bufferModelConfig, MatOfByte bufferWeights) {
        MatOfByte bufferModelConfig_mat = bufferModelConfig;
        MatOfByte bufferWeights_mat = bufferWeights;
        return new Net(Net.readFromModelOptimizer_1(bufferModelConfig_mat.nativeObj, bufferWeights_mat.nativeObj));
    }

    public boolean empty() {
        return Net.empty_0(this.nativeObj);
    }

    public String dump() {
        return Net.dump_0(this.nativeObj);
    }

    public void dumpToFile(String path) {
        Net.dumpToFile_0(this.nativeObj, path);
    }

    public void dumpToPbtxt(String path) {
        Net.dumpToPbtxt_0(this.nativeObj, path);
    }

    public int getLayerId(String layer) {
        return Net.getLayerId_0(this.nativeObj, layer);
    }

    public List<String> getLayerNames() {
        return Net.getLayerNames_0(this.nativeObj);
    }

    public Layer getLayer(int layerId) {
        return Layer.__fromPtr__(Net.getLayer_0(this.nativeObj, layerId));
    }

    @Deprecated
    public Layer getLayer(String layerName) {
        return Layer.__fromPtr__(Net.getLayer_1(this.nativeObj, layerName));
    }

    @Deprecated
    public Layer getLayer(DictValue layerId) {
        return Layer.__fromPtr__(Net.getLayer_2(this.nativeObj, layerId.getNativeObjAddr()));
    }

    public void connect(String outPin, String inpPin) {
        Net.connect_0(this.nativeObj, outPin, inpPin);
    }

    public void setInputsNames(List<String> inputBlobNames) {
        Net.setInputsNames_0(this.nativeObj, inputBlobNames);
    }

    public void setInputShape(String inputName, MatOfInt shape) {
        MatOfInt shape_mat = shape;
        Net.setInputShape_0(this.nativeObj, inputName, shape_mat.nativeObj);
    }

    public Mat forward(String outputName) {
        return new Mat(Net.forward_0(this.nativeObj, outputName));
    }

    public Mat forward() {
        return new Mat(Net.forward_1(this.nativeObj));
    }

    public void forward(List<Mat> outputBlobs, String outputName) {
        Mat outputBlobs_mat = new Mat();
        Net.forward_2(this.nativeObj, outputBlobs_mat.nativeObj, outputName);
        Converters.Mat_to_vector_Mat(outputBlobs_mat, outputBlobs);
        outputBlobs_mat.release();
    }

    public void forward(List<Mat> outputBlobs) {
        Mat outputBlobs_mat = new Mat();
        Net.forward_3(this.nativeObj, outputBlobs_mat.nativeObj);
        Converters.Mat_to_vector_Mat(outputBlobs_mat, outputBlobs);
        outputBlobs_mat.release();
    }

    public void forward(List<Mat> outputBlobs, List<String> outBlobNames) {
        Mat outputBlobs_mat = new Mat();
        Net.forward_4(this.nativeObj, outputBlobs_mat.nativeObj, outBlobNames);
        Converters.Mat_to_vector_Mat(outputBlobs_mat, outputBlobs);
        outputBlobs_mat.release();
    }

    public Net quantize(List<Mat> calibData, int inputsDtype, int outputsDtype, boolean perChannel) {
        Mat calibData_mat = Converters.vector_Mat_to_Mat(calibData);
        return new Net(Net.quantize_0(this.nativeObj, calibData_mat.nativeObj, inputsDtype, outputsDtype, perChannel));
    }

    public Net quantize(List<Mat> calibData, int inputsDtype, int outputsDtype) {
        Mat calibData_mat = Converters.vector_Mat_to_Mat(calibData);
        return new Net(Net.quantize_1(this.nativeObj, calibData_mat.nativeObj, inputsDtype, outputsDtype));
    }

    public void getInputDetails(MatOfFloat scales, MatOfInt zeropoints) {
        MatOfFloat scales_mat = scales;
        MatOfInt zeropoints_mat = zeropoints;
        Net.getInputDetails_0(this.nativeObj, scales_mat.nativeObj, zeropoints_mat.nativeObj);
    }

    public void getOutputDetails(MatOfFloat scales, MatOfInt zeropoints) {
        MatOfFloat scales_mat = scales;
        MatOfInt zeropoints_mat = zeropoints;
        Net.getOutputDetails_0(this.nativeObj, scales_mat.nativeObj, zeropoints_mat.nativeObj);
    }

    public void setHalideScheduler(String scheduler) {
        Net.setHalideScheduler_0(this.nativeObj, scheduler);
    }

    public void setPreferableBackend(int backendId) {
        Net.setPreferableBackend_0(this.nativeObj, backendId);
    }

    public void setPreferableTarget(int targetId) {
        Net.setPreferableTarget_0(this.nativeObj, targetId);
    }

    public void setInput(Mat blob, String name, double scalefactor, Scalar mean) {
        Net.setInput_0(this.nativeObj, blob.nativeObj, name, scalefactor, mean.val[0], mean.val[1], mean.val[2], mean.val[3]);
    }

    public void setInput(Mat blob, String name, double scalefactor) {
        Net.setInput_1(this.nativeObj, blob.nativeObj, name, scalefactor);
    }

    public void setInput(Mat blob, String name) {
        Net.setInput_2(this.nativeObj, blob.nativeObj, name);
    }

    public void setInput(Mat blob) {
        Net.setInput_3(this.nativeObj, blob.nativeObj);
    }

    public void setParam(int layer, int numParam, Mat blob) {
        Net.setParam_0(this.nativeObj, layer, numParam, blob.nativeObj);
    }

    public void setParam(String layerName, int numParam, Mat blob) {
        Net.setParam_1(this.nativeObj, layerName, numParam, blob.nativeObj);
    }

    public Mat getParam(int layer, int numParam) {
        return new Mat(Net.getParam_0(this.nativeObj, layer, numParam));
    }

    public Mat getParam(int layer) {
        return new Mat(Net.getParam_1(this.nativeObj, layer));
    }

    public Mat getParam(String layerName, int numParam) {
        return new Mat(Net.getParam_2(this.nativeObj, layerName, numParam));
    }

    public Mat getParam(String layerName) {
        return new Mat(Net.getParam_3(this.nativeObj, layerName));
    }

    public MatOfInt getUnconnectedOutLayers() {
        return MatOfInt.fromNativeAddr(Net.getUnconnectedOutLayers_0(this.nativeObj));
    }

    public List<String> getUnconnectedOutLayersNames() {
        return Net.getUnconnectedOutLayersNames_0(this.nativeObj);
    }

    public long getFLOPS(List<MatOfInt> netInputShapes) {
        return Net.getFLOPS_0(this.nativeObj, netInputShapes);
    }

    public long getFLOPS(MatOfInt netInputShape) {
        MatOfInt netInputShape_mat = netInputShape;
        return Net.getFLOPS_1(this.nativeObj, netInputShape_mat.nativeObj);
    }

    public long getFLOPS(int layerId, List<MatOfInt> netInputShapes) {
        return Net.getFLOPS_2(this.nativeObj, layerId, netInputShapes);
    }

    public long getFLOPS(int layerId, MatOfInt netInputShape) {
        MatOfInt netInputShape_mat = netInputShape;
        return Net.getFLOPS_3(this.nativeObj, layerId, netInputShape_mat.nativeObj);
    }

    public void getLayerTypes(List<String> layersTypes) {
        Net.getLayerTypes_0(this.nativeObj, layersTypes);
    }

    public int getLayersCount(String layerType) {
        return Net.getLayersCount_0(this.nativeObj, layerType);
    }

    public void getMemoryConsumption(MatOfInt netInputShape, long[] weights, long[] blobs) {
        MatOfInt netInputShape_mat = netInputShape;
        double[] weights_out = new double[1];
        double[] blobs_out = new double[1];
        Net.getMemoryConsumption_0(this.nativeObj, netInputShape_mat.nativeObj, weights_out, blobs_out);
        if (weights != null) {
            weights[0] = (long)weights_out[0];
        }
        if (blobs != null) {
            blobs[0] = (long)blobs_out[0];
        }
    }

    public void getMemoryConsumption(int layerId, List<MatOfInt> netInputShapes, long[] weights, long[] blobs) {
        double[] weights_out = new double[1];
        double[] blobs_out = new double[1];
        Net.getMemoryConsumption_1(this.nativeObj, layerId, netInputShapes, weights_out, blobs_out);
        if (weights != null) {
            weights[0] = (long)weights_out[0];
        }
        if (blobs != null) {
            blobs[0] = (long)blobs_out[0];
        }
    }

    public void getMemoryConsumption(int layerId, MatOfInt netInputShape, long[] weights, long[] blobs) {
        MatOfInt netInputShape_mat = netInputShape;
        double[] weights_out = new double[1];
        double[] blobs_out = new double[1];
        Net.getMemoryConsumption_2(this.nativeObj, layerId, netInputShape_mat.nativeObj, weights_out, blobs_out);
        if (weights != null) {
            weights[0] = (long)weights_out[0];
        }
        if (blobs != null) {
            blobs[0] = (long)blobs_out[0];
        }
    }

    public void enableFusion(boolean fusion) {
        Net.enableFusion_0(this.nativeObj, fusion);
    }

    public void enableWinograd(boolean useWinograd) {
        Net.enableWinograd_0(this.nativeObj, useWinograd);
    }

    public long getPerfProfile(MatOfDouble timings) {
        MatOfDouble timings_mat = timings;
        return Net.getPerfProfile_0(this.nativeObj, timings_mat.nativeObj);
    }

    protected void finalize() throws Throwable {
        Net.delete(this.nativeObj);
    }

    private static native long Net_0();

    private static native long readFromModelOptimizer_0(String var0, String var1);

    private static native long readFromModelOptimizer_1(long var0, long var2);

    private static native boolean empty_0(long var0);

    private static native String dump_0(long var0);

    private static native void dumpToFile_0(long var0, String var2);

    private static native void dumpToPbtxt_0(long var0, String var2);

    private static native int getLayerId_0(long var0, String var2);

    private static native List<String> getLayerNames_0(long var0);

    private static native long getLayer_0(long var0, int var2);

    private static native long getLayer_1(long var0, String var2);

    private static native long getLayer_2(long var0, long var2);

    private static native void connect_0(long var0, String var2, String var3);

    private static native void setInputsNames_0(long var0, List<String> var2);

    private static native void setInputShape_0(long var0, String var2, long var3);

    private static native long forward_0(long var0, String var2);

    private static native long forward_1(long var0);

    private static native void forward_2(long var0, long var2, String var4);

    private static native void forward_3(long var0, long var2);

    private static native void forward_4(long var0, long var2, List<String> var4);

    private static native long quantize_0(long var0, long var2, int var4, int var5, boolean var6);

    private static native long quantize_1(long var0, long var2, int var4, int var5);

    private static native void getInputDetails_0(long var0, long var2, long var4);

    private static native void getOutputDetails_0(long var0, long var2, long var4);

    private static native void setHalideScheduler_0(long var0, String var2);

    private static native void setPreferableBackend_0(long var0, int var2);

    private static native void setPreferableTarget_0(long var0, int var2);

    private static native void setInput_0(long var0, long var2, String var4, double var5, double var7, double var9, double var11, double var13);

    private static native void setInput_1(long var0, long var2, String var4, double var5);

    private static native void setInput_2(long var0, long var2, String var4);

    private static native void setInput_3(long var0, long var2);

    private static native void setParam_0(long var0, int var2, int var3, long var4);

    private static native void setParam_1(long var0, String var2, int var3, long var4);

    private static native long getParam_0(long var0, int var2, int var3);

    private static native long getParam_1(long var0, int var2);

    private static native long getParam_2(long var0, String var2, int var3);

    private static native long getParam_3(long var0, String var2);

    private static native long getUnconnectedOutLayers_0(long var0);

    private static native List<String> getUnconnectedOutLayersNames_0(long var0);

    private static native long getFLOPS_0(long var0, List<MatOfInt> var2);

    private static native long getFLOPS_1(long var0, long var2);

    private static native long getFLOPS_2(long var0, int var2, List<MatOfInt> var3);

    private static native long getFLOPS_3(long var0, int var2, long var3);

    private static native void getLayerTypes_0(long var0, List<String> var2);

    private static native int getLayersCount_0(long var0, String var2);

    private static native void getMemoryConsumption_0(long var0, long var2, double[] var4, double[] var5);

    private static native void getMemoryConsumption_1(long var0, int var2, List<MatOfInt> var3, double[] var4, double[] var5);

    private static native void getMemoryConsumption_2(long var0, int var2, long var3, double[] var5, double[] var6);

    private static native void enableFusion_0(long var0, boolean var2);

    private static native void enableWinograd_0(long var0, boolean var2);

    private static native long getPerfProfile_0(long var0, long var2);

    private static native void delete(long var0);
}

