/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import java.util.Objects;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;

public class MnemonicInfo {
    private final char MNEMONIC_SYMBOL = (char)95;
    private String sourceText = null;
    private String text = null;
    private String mnemonic = null;
    private KeyCombination mnemonicKeyCombination = null;
    private int mnemonicIndex = -1;
    private String extendedMnemonicText = null;

    public String getText() {
        return this.text;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public KeyCombination getMnemonicKeyCombination() {
        if (this.mnemonic != null && this.mnemonicKeyCombination == null) {
            this.mnemonicKeyCombination = new MnemonicKeyCombination(this.mnemonic);
        }
        return this.mnemonicKeyCombination;
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public String getExtendedMnemonicText() {
        return this.extendedMnemonicText;
    }

    public MnemonicInfo(String string) {
        this.update(string);
    }

    public void update(String string) {
        if (!Objects.equals(this.sourceText, string)) {
            this.sourceText = string;
            this.mnemonic = null;
            this.mnemonicKeyCombination = null;
            this.mnemonicIndex = -1;
            this.extendedMnemonicText = null;
            this.parseAndSplit(string);
        }
    }

    private void parseAndSplit(String string) {
        int n;
        if (string == null || string.length() == 0) {
            this.text = string;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = string.length();
        for (n = 0; n < n2; ++n) {
            if (this.isEscapedMnemonicSymbol(string, n)) {
                stringBuilder.append(string.charAt(n++));
                continue;
            }
            if (this.isExtendedMnemonic(string, n)) {
                this.mnemonic = String.valueOf(string.charAt(n + 2));
                this.mnemonicIndex = n;
                this.extendedMnemonicText = string.substring(n + 1, n + 4);
                n += 4;
                break;
            }
            if (this.isSimpleMnemonic(string, n)) {
                char c = string.charAt(n + 1);
                this.mnemonic = String.valueOf(c);
                this.mnemonicIndex = n++;
                break;
            }
            stringBuilder.append(string.charAt(n));
        }
        if (string.length() > n) {
            stringBuilder.append(string.substring(n));
        }
        this.text = stringBuilder.toString();
    }

    private boolean isEscapedMnemonicSymbol(String string, int n) {
        return string.length() > n + 1 && string.charAt(n) == '_' && string.charAt(n + 1) == '_';
    }

    private boolean isSimpleMnemonic(String string, int n) {
        return string.length() > n + 1 && string.charAt(n) == '_' && string.charAt(n + 1) != '_' && !Character.isWhitespace(string.charAt(n + 1));
    }

    private boolean isExtendedMnemonic(String string, int n) {
        return string.length() > n + 3 && string.charAt(n) == '_' && string.charAt(n + 1) == '(' && !Character.isWhitespace(string.charAt(n + 2)) && string.charAt(n + 3) == ')';
    }

    public static class MnemonicKeyCombination
    extends KeyCombination {
        private String character = "";

        public MnemonicKeyCombination(String string) {
            super(PlatformUtil.isMac() ? KeyCombination.META_DOWN : KeyCombination.ALT_DOWN);
            this.character = string;
        }

        public final String getCharacter() {
            return this.character;
        }

        @Override
        public boolean match(KeyEvent keyEvent) {
            String string = keyEvent.getText();
            return string != null && !string.isEmpty() && string.equalsIgnoreCase(this.getCharacter()) && super.match(keyEvent);
        }

        @Override
        public String getName() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.getName());
            if (stringBuilder.length() > 0) {
                stringBuilder.append("+");
            }
            return stringBuilder.append('\'').append(this.character.replace("'", "\\'")).append('\'').toString();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof MnemonicKeyCombination)) {
                return false;
            }
            return this.character.equals(((MnemonicKeyCombination)object).getCharacter()) && super.equals(object);
        }

        @Override
        public int hashCode() {
            return 23 * super.hashCode() + this.character.hashCode();
        }
    }
}

