/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v137.bluetoothemulation.model;

import java.util.List;
import java.util.Optional;
import org.openqa.selenium.devtools.v137.bluetoothemulation.model.ManufacturerData;
import org.openqa.selenium.json.JsonInput;

public class ScanRecord {
    private final Optional<String> name;
    private final Optional<List<String>> uuids;
    private final Optional<Integer> appearance;
    private final Optional<Integer> txPower;
    private final Optional<List<ManufacturerData>> manufacturerData;

    public ScanRecord(Optional<String> name, Optional<List<String>> uuids, Optional<Integer> appearance, Optional<Integer> txPower, Optional<List<ManufacturerData>> manufacturerData) {
        this.name = name;
        this.uuids = uuids;
        this.appearance = appearance;
        this.txPower = txPower;
        this.manufacturerData = manufacturerData;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<List<String>> getUuids() {
        return this.uuids;
    }

    public Optional<Integer> getAppearance() {
        return this.appearance;
    }

    public Optional<Integer> getTxPower() {
        return this.txPower;
    }

    public Optional<List<ManufacturerData>> getManufacturerData() {
        return this.manufacturerData;
    }

    private static ScanRecord fromJson(JsonInput input) {
        Optional<String> name = Optional.empty();
        Optional<List<String>> uuids = Optional.empty();
        Optional<Integer> appearance = Optional.empty();
        Optional<Integer> txPower = Optional.empty();
        Optional<List<ManufacturerData>> manufacturerData = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = Optional.ofNullable(input.nextString());
                    continue block14;
                }
                case "uuids": {
                    uuids = Optional.ofNullable(input.readArray(String.class));
                    continue block14;
                }
                case "appearance": {
                    appearance = Optional.ofNullable(input.nextNumber().intValue());
                    continue block14;
                }
                case "txPower": {
                    txPower = Optional.ofNullable(input.nextNumber().intValue());
                    continue block14;
                }
                case "manufacturerData": {
                    manufacturerData = Optional.ofNullable(input.readArray(ManufacturerData.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScanRecord(name, uuids, appearance, txPower, manufacturerData);
    }
}

