/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file.attribute;

import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.io.file.attribute.FileTimes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class FileTimesTest {
    public static Stream<Arguments> fileTimeNanoUnitsToNtfsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.0000000Z", 0}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.0000001Z", 1}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.0000010Z", 10}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.0000100Z", 100}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.0001000Z", 1000}), Arguments.of((Object[])new Object[]{"1600-12-31T23:59:59.9999999Z", -1}), Arguments.of((Object[])new Object[]{"+30828-09-14T02:48:05.477580700Z", Long.MAX_VALUE}), Arguments.of((Object[])new Object[]{"+30828-09-14T02:48:05.477580600Z", 0x7FFFFFFFFFFFFFFEL}), Arguments.of((Object[])new Object[]{"+30828-09-14T02:48:05.477579700Z", 0x7FFFFFFFFFFFFFF5L}), Arguments.of((Object[])new Object[]{"+30828-09-14T02:48:05.477570700Z", 9223372036854775707L}), Arguments.of((Object[])new Object[]{"+30828-09-14T02:48:05.477480700Z", 9223372036854774807L}), Arguments.of((Object[])new Object[]{"-27627-04-19T21:11:54.522419200Z", Long.MIN_VALUE}), Arguments.of((Object[])new Object[]{"-27627-04-19T21:11:54.522419300Z", -9223372036854775807L}), Arguments.of((Object[])new Object[]{"-27627-04-19T21:11:54.522420200Z", -9223372036854775798L}), Arguments.of((Object[])new Object[]{"-27627-04-19T21:11:54.522429200Z", -9223372036854775708L}), Arguments.of((Object[])new Object[]{"-27627-04-19T21:11:54.522519200Z", -9223372036854774808L}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.0010000Z", FileTimes.HUNDRED_NANOS_PER_MILLISECOND}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.0010001Z", FileTimes.HUNDRED_NANOS_PER_MILLISECOND + 1L}), Arguments.of((Object[])new Object[]{"1601-01-01T00:00:00.0009999Z", FileTimes.HUNDRED_NANOS_PER_MILLISECOND - 1L}), Arguments.of((Object[])new Object[]{"1600-12-31T23:59:59.9990000Z", -FileTimes.HUNDRED_NANOS_PER_MILLISECOND}), Arguments.of((Object[])new Object[]{"1600-12-31T23:59:59.9990001Z", -FileTimes.HUNDRED_NANOS_PER_MILLISECOND + 1L}), Arguments.of((Object[])new Object[]{"1600-12-31T23:59:59.9989999Z", -FileTimes.HUNDRED_NANOS_PER_MILLISECOND - 1L}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00.0000000Z", 116444736000000000L}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00.0000001Z", 116444736000000001L}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00.0010000Z", 116444736000000000L + FileTimes.HUNDRED_NANOS_PER_MILLISECOND}), Arguments.of((Object[])new Object[]{"1969-12-31T23:59:59.9999999Z", 116444735999999999L}), Arguments.of((Object[])new Object[]{"1969-12-31T23:59:59.9990000Z", 116444736000000000L - FileTimes.HUNDRED_NANOS_PER_MILLISECOND}));
    }

    public static Stream<Arguments> fileTimeToNtfsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00Z", FileTime.from(Instant.EPOCH)}), Arguments.of((Object[])new Object[]{"1969-12-31T23:59:00Z", FileTime.from(Instant.EPOCH.minusSeconds(60L))}), Arguments.of((Object[])new Object[]{"1970-01-01T00:01:00Z", FileTime.from(Instant.EPOCH.plusSeconds(60L))}));
    }

    public static Stream<Arguments> isUnixFileTimeProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{"2022-12-27T12:45:22Z", true}), Arguments.of((Object[])new Object[]{"2038-01-19T03:14:07Z", true}), Arguments.of((Object[])new Object[]{"1901-12-13T23:14:08Z", true}), Arguments.of((Object[])new Object[]{"1901-12-13T03:14:08Z", false}), Arguments.of((Object[])new Object[]{"2038-01-19T03:14:08Z", false}), Arguments.of((Object[])new Object[]{"2099-06-30T12:31:42Z", false}));
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeNanoUnitsToNtfsProvider"})
    public void testDateToFileTime(String instant, long ignored) {
        Instant parsedInstant = Instant.parse(instant);
        FileTime parsedFileTime = FileTime.from(parsedInstant);
        Date parsedDate = Date.from(parsedInstant);
        Assertions.assertEquals((long)parsedFileTime.toMillis(), (long)FileTimes.toFileTime((Date)parsedDate).toMillis());
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeNanoUnitsToNtfsProvider"})
    public void testDateToNtfsTime(String instantStr, long ntfsTime) {
        long ntfsMillis = Math.floorDiv(ntfsTime, FileTimes.HUNDRED_NANOS_PER_MILLISECOND) * FileTimes.HUNDRED_NANOS_PER_MILLISECOND;
        Instant instant = Instant.parse(instantStr);
        Date parsed = Date.from(instant);
        long ntfsTime2 = FileTimes.toNtfsTime((Date)parsed);
        if (ntfsTime2 != Long.MIN_VALUE && ntfsTime2 != Long.MAX_VALUE) {
            Assertions.assertEquals((long)ntfsMillis, (long)ntfsTime2);
            Assertions.assertEquals((long)ntfsMillis, (long)FileTimes.toNtfsTime((long)parsed.getTime()));
            Assertions.assertEquals((long)ntfsMillis, (long)FileTimes.toNtfsTime((long)FileTimes.ntfsTimeToInstant((long)ntfsTime).toEpochMilli()));
        }
        Assertions.assertEquals((long)ntfsTime, (long)FileTimes.toNtfsTime((Instant)FileTimes.ntfsTimeToInstant((long)ntfsTime)));
    }

    @Test
    public void testEpoch() {
        Assertions.assertEquals((long)0L, (long)FileTimes.EPOCH.toMillis());
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeNanoUnitsToNtfsProvider"})
    public void testFileTimeToDate(String instant, long ignored) {
        Instant parsedInstant = Instant.parse(instant);
        FileTime parsedFileTime = FileTime.from(parsedInstant);
        Date parsedDate = Date.from(parsedInstant);
        Assertions.assertEquals((Object)parsedDate, (Object)FileTimes.toDate((FileTime)parsedFileTime));
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeToNtfsProvider"})
    public void testFileTimeToNtfsTime(String instantStr, FileTime fileTime) {
        Instant instant = Instant.parse(instantStr);
        FileTime parsed = FileTime.from(instant);
        Assertions.assertEquals((Object)instant, (Object)parsed.toInstant());
        Assertions.assertEquals((Object)fileTime, (Object)FileTimes.ntfsTimeToFileTime((long)FileTimes.toNtfsTime((FileTime)parsed)));
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeNanoUnitsToNtfsProvider"})
    public void testFileTimeToNtfsTime(String instant, long ntfsTime) {
        FileTime parsed = FileTime.from(Instant.parse(instant));
        Assertions.assertEquals((long)ntfsTime, (long)FileTimes.toNtfsTime((FileTime)parsed));
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeNanoUnitsToNtfsProvider"})
    public void testFromUnixTime(String instant, long ntfsTime) {
        long epochSecond = Instant.parse(instant).getEpochSecond();
        Assertions.assertEquals((long)epochSecond, (long)FileTimes.fromUnixTime((long)epochSecond).to(TimeUnit.SECONDS));
    }

    @ParameterizedTest
    @MethodSource(value={"isUnixFileTimeProvider"})
    public void testIsUnixTime(String instant, boolean isUnixTime) {
        Assertions.assertEquals((Object)isUnixTime, (Object)FileTimes.isUnixTime((FileTime)FileTime.from(Instant.parse(instant))));
    }

    public void testIsUnixTimeFileTimeNull() {
        Assertions.assertTrue((boolean)FileTimes.isUnixTime(null));
    }

    @ParameterizedTest
    @MethodSource(value={"isUnixFileTimeProvider"})
    public void testIsUnixTimeLong(String instant, boolean isUnixTime) {
        Assertions.assertEquals((Object)isUnixTime, (Object)FileTimes.isUnixTime((long)Instant.parse(instant).getEpochSecond()));
    }

    @Test
    public void testMaxJavaTime() {
        long javaTime = Long.MAX_VALUE;
        Instant instant = Instant.ofEpochMilli(Long.MAX_VALUE);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)instant.toEpochMilli());
        long ntfsTime = FileTimes.toNtfsTime((long)Long.MAX_VALUE);
        Instant instant2 = FileTimes.ntfsTimeToInstant((long)ntfsTime);
        if (ntfsTime != Long.MAX_VALUE) {
            Assertions.assertEquals((long)Long.MAX_VALUE, (long)instant2.toEpochMilli());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeNanoUnitsToNtfsProvider"})
    public void testMaxJavaTimeParam(String instantStr, long javaTime) {
        Instant instant = Instant.ofEpochMilli(javaTime);
        Assertions.assertEquals((long)javaTime, (long)instant.toEpochMilli());
        long ntfsTime = FileTimes.toNtfsTime((long)javaTime);
        Instant instant2 = FileTimes.ntfsTimeToInstant((long)ntfsTime);
        if (ntfsTime != Long.MIN_VALUE && ntfsTime != Long.MAX_VALUE) {
            Assertions.assertEquals((long)javaTime, (long)instant2.toEpochMilli());
        }
    }

    @Test
    public void testMinusMillis() {
        int millis = 2;
        Assertions.assertEquals((Object)Instant.EPOCH.minusMillis(2L), (Object)FileTimes.minusMillis((FileTime)FileTimes.EPOCH, (long)2L).toInstant());
        Assertions.assertEquals((Object)Instant.EPOCH, (Object)FileTimes.minusMillis((FileTime)FileTimes.EPOCH, (long)0L).toInstant());
    }

    @Test
    public void testMinusNanos() {
        int millis = 2;
        Assertions.assertEquals((Object)Instant.EPOCH.minusNanos(2L), (Object)FileTimes.minusNanos((FileTime)FileTimes.EPOCH, (long)2L).toInstant());
        Assertions.assertEquals((Object)Instant.EPOCH, (Object)FileTimes.minusNanos((FileTime)FileTimes.EPOCH, (long)0L).toInstant());
    }

    @Test
    public void testMinusSeconds() {
        int seconds = 2;
        Assertions.assertEquals((Object)Instant.EPOCH.minusSeconds(2L), (Object)FileTimes.minusSeconds((FileTime)FileTimes.EPOCH, (long)2L).toInstant());
        Assertions.assertEquals((Object)Instant.EPOCH, (Object)FileTimes.minusSeconds((FileTime)FileTimes.EPOCH, (long)0L).toInstant());
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeNanoUnitsToNtfsProvider"})
    public void testNtfsTimeToDate(String instant, long ntfsTime) {
        Assertions.assertEquals((long)Instant.parse(instant).toEpochMilli(), (long)FileTimes.ntfsTimeToDate((long)ntfsTime).toInstant().toEpochMilli());
    }

    @ParameterizedTest
    @MethodSource(value={"fileTimeNanoUnitsToNtfsProvider"})
    public void testNtfsTimeToFileTime(String instantStr, long ntfsTime) {
        Instant instant = Instant.parse(instantStr);
        FileTime fileTime = FileTime.from(instant);
        Assertions.assertEquals((Object)instant, (Object)fileTime.toInstant());
        Assertions.assertEquals((Object)instant, (Object)FileTimes.ntfsTimeToInstant((long)ntfsTime));
        Assertions.assertEquals((Object)fileTime, (Object)FileTimes.ntfsTimeToFileTime((long)ntfsTime));
    }

    @Test
    public void testNullDateToNullFileTime() {
        Assertions.assertNull((Object)FileTimes.toFileTime(null));
    }

    @Test
    public void testNullFileTimeToNullDate() {
        Assertions.assertNull((Object)FileTimes.toDate(null));
    }

    @Test
    public void testPlusMinusMillis() {
        int millis = 2;
        Assertions.assertEquals((Object)Instant.EPOCH.plusMillis(2L), (Object)FileTimes.plusMillis((FileTime)FileTimes.EPOCH, (long)2L).toInstant());
        Assertions.assertEquals((Object)Instant.EPOCH, (Object)FileTimes.plusMillis((FileTime)FileTimes.EPOCH, (long)0L).toInstant());
    }

    @Test
    public void testPlusNanos() {
        int millis = 2;
        Assertions.assertEquals((Object)Instant.EPOCH.plusNanos(2L), (Object)FileTimes.plusNanos((FileTime)FileTimes.EPOCH, (long)2L).toInstant());
        Assertions.assertEquals((Object)Instant.EPOCH, (Object)FileTimes.plusNanos((FileTime)FileTimes.EPOCH, (long)0L).toInstant());
    }

    @Test
    public void testPlusSeconds() {
        int seconds = 2;
        Assertions.assertEquals((Object)Instant.EPOCH.plusSeconds(2L), (Object)FileTimes.plusSeconds((FileTime)FileTimes.EPOCH, (long)2L).toInstant());
        Assertions.assertEquals((Object)Instant.EPOCH, (Object)FileTimes.plusSeconds((FileTime)FileTimes.EPOCH, (long)0L).toInstant());
    }

    @ParameterizedTest
    @MethodSource(value={"isUnixFileTimeProvider"})
    public void testToUnixTime(String instant, boolean isUnixTime) {
        Assertions.assertEquals((Object)isUnixTime, (Object)FileTimes.isUnixTime((long)FileTimes.toUnixTime((FileTime)FileTime.from(Instant.parse(instant)))));
    }
}

