/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.PathUtils;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class PathUtilsCleanDirectoryTest {
    @TempDir
    private Path tempDir;

    @Test
    public void testCleanDirectory1FileSize0() throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(1L, 1L, 0L, PathUtils.cleanDirectory((Path)this.tempDir));
    }

    @Test
    public void testCleanDirectory1FileSize1() throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(1L, 1L, 1L, PathUtils.cleanDirectory((Path)this.tempDir));
    }

    @Test
    public void testCleanDirectory2FileSize2() throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(3L, 2L, 2L, PathUtils.cleanDirectory((Path)this.tempDir));
    }

    @Test
    public void testCleanEmptyDirectory() throws IOException {
        CounterAssertions.assertCounts(1L, 0L, 0L, PathUtils.cleanDirectory((Path)this.tempDir));
    }
}

