/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor;

import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class StatusHandler
implements HttpHandler {
    private final Distributor distributor;

    StatusHandler(Distributor distributor) {
        this.distributor = Require.nonNull("Distributor", distributor);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        DistributorStatus status = this.distributor.getStatus();
        ImmutableMap<String, ImmutableMap<String, DistributorStatus>> report = ImmutableMap.of("value", ImmutableMap.of("ready", status.hasCapacity(), "message", status.hasCapacity() ? "Ready" : "No free slots available", "grid", status));
        return (HttpResponse)new HttpResponse().setContent(Contents.asJson(report));
    }
}

