/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.function.IOBiConsumer;
import org.apache.commons.io.function.IOBiFunction;
import org.apache.commons.io.function.IOBinaryOperator;
import org.apache.commons.io.function.IOComparator;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOIntConsumer;
import org.apache.commons.io.function.IOPredicate;
import org.apache.commons.io.function.IORunnable;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.IOUnaryOperator;
import org.apache.commons.io.function.TestConstants;

final class TestUtils {
    TestUtils() {
    }

    static int compareAndSetThrowsIO(AtomicInteger ref, int update) throws IOException {
        return TestUtils.compareAndSetThrowsIO(ref, 0, update);
    }

    static int compareAndSetThrowsIO(AtomicInteger ref, int expected, int update) throws IOException {
        if (!ref.compareAndSet(expected, update)) {
            throw new IOException("Unexpected");
        }
        return ref.get();
    }

    static long compareAndSetThrowsIO(AtomicLong ref, long update) throws IOException {
        return TestUtils.compareAndSetThrowsIO(ref, 0L, update);
    }

    static long compareAndSetThrowsIO(AtomicLong ref, long expected, long update) throws IOException {
        if (!ref.compareAndSet(expected, update)) {
            throw new IOException("Unexpected");
        }
        return ref.get();
    }

    static <T> T compareAndSetThrowsIO(AtomicReference<T> ref, T update) throws IOException {
        return TestUtils.compareAndSetThrowsIO(ref, null, update);
    }

    static <T> T compareAndSetThrowsIO(AtomicReference<T> ref, T expected, T update) throws IOException {
        if (!ref.compareAndSet(expected, update)) {
            throw new IOException("Unexpected");
        }
        return ref.get();
    }

    static <T> T compareAndSetThrowsRE(AtomicReference<T> ref, T expected, T update) {
        if (!ref.compareAndSet(expected, update)) {
            throw new RuntimeException("Unexpected");
        }
        return ref.get();
    }

    static <T, U> IOBiConsumer<T, U> throwingIOBiConsumer() {
        return TestConstants.THROWING_IO_BI_CONSUMER;
    }

    static <T, U, V> IOBiFunction<T, U, V> throwingIOBiFunction() {
        return TestConstants.THROWING_IO_BI_FUNCTION;
    }

    static <T> IOBinaryOperator<T> throwingIOBinaryOperator() {
        return TestConstants.THROWING_IO_BINARY_OPERATOR;
    }

    static <T> IOComparator<T> throwingIOComparator() {
        return TestConstants.THROWING_IO_COMPARATOR;
    }

    static <T> IOConsumer<T> throwingIOConsumer() {
        return TestConstants.THROWING_IO_CONSUMER;
    }

    static <T, U> IOFunction<T, U> throwingIOFunction() {
        return TestConstants.THROWING_IO_FUNCTION;
    }

    static IOIntConsumer throwingIOIntConsumer() {
        return TestConstants.THROWING_IO_INT_CONSUMER;
    }

    static <T> IOPredicate<T> throwingIOPredicate() {
        return TestConstants.THROWING_IO_PREDICATE;
    }

    static IORunnable throwingIORunnable() {
        return TestConstants.THROWING_IO_RUNNABLE;
    }

    static <T> IOSupplier<T> throwingIOSupplier() {
        return TestConstants.THROWING_IO_SUPPLIER;
    }

    static <T> IOUnaryOperator<T> throwingIOUnaryOperator() {
        return TestConstants.THROWING_IO_UNARY_OPERATOR;
    }
}

