/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.TestConstants;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOFunctionTest {
    @Test
    public void testAndThenConsumer() throws IOException {
        Holder holder = new Holder();
        IOFunction<InputStream, Integer> readByte = InputStream::read;
        Consumer<Integer> sinkInteger = i -> {
            holder.value = i * i;
        };
        IOConsumer<InputStream> productFunction = readByte.andThen(sinkInteger);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{2, 3});
        productFunction.accept(is);
        Assertions.assertEquals((int)4, (Integer)((Integer)holder.value));
        productFunction.accept(is);
        Assertions.assertEquals((int)9, (Integer)((Integer)holder.value));
    }

    @Test
    public void testAndThenFunction() throws IOException {
        IOFunction<InputStream, Integer> readByte = InputStream::read;
        Function<Integer, Integer> squareInteger = i -> i * i;
        IOFunction<InputStream, Integer> productFunction = readByte.andThen(squareInteger);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{2, 3});
        Assertions.assertEquals((int)4, (Integer)productFunction.apply(is));
        Assertions.assertEquals((int)9, (Integer)productFunction.apply(is));
    }

    @Test
    public void testAndThenIOConsumer() throws IOException {
        Holder holder = new Holder();
        IOFunction<InputStream, Integer> readByte = InputStream::read;
        IOConsumer<Integer> sinkInteger = i -> {
            holder.value = i * i;
        };
        IOConsumer<InputStream> productFunction = readByte.andThen(sinkInteger);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{2, 3});
        productFunction.accept(is);
        Assertions.assertEquals((int)4, (Integer)((Integer)holder.value));
        productFunction.accept(is);
        Assertions.assertEquals((int)9, (Integer)((Integer)holder.value));
    }

    @Test
    public void testAndThenIOFunction() throws IOException {
        IOFunction<InputStream, Integer> readByte = InputStream::read;
        IOFunction<Integer, Integer> squareInteger = i -> i * i;
        IOFunction<InputStream, Integer> productFunction = readByte.andThen(squareInteger);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{2, 3});
        Assertions.assertEquals((int)4, (Integer)productFunction.apply(is));
        Assertions.assertEquals((int)9, (Integer)productFunction.apply(is));
    }

    @Test
    public void testApply() throws IOException {
        IOFunction<InputStream, Integer> readByte = InputStream::read;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)10, (Integer)readByte.apply(is));
        Assertions.assertEquals((int)11, (Integer)readByte.apply(is));
        Assertions.assertEquals((int)12, (Integer)readByte.apply(is));
        Assertions.assertEquals((int)-1, (Integer)readByte.apply(is));
    }

    @Test
    public void testApplyThrowsException() {
        IOFunction<InputStream, Integer> throwException = function -> {
            throw new IOException("Boom!");
        };
        Assertions.assertThrows(IOException.class, () -> throwException.apply(new ByteArrayInputStream(ArrayUtils.EMPTY_BYTE_ARRAY)));
    }

    @Test
    public void testAsFunction() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Optional.of("a").map(TestConstants.THROWING_IO_FUNCTION.asFunction()).get());
        Assertions.assertEquals((Object)"a", Optional.of("a").map(IOFunction.identity().asFunction()).get());
    }

    @Test
    public void testComposeFunction() throws IOException {
        Function<InputStream, Integer> alwaysSeven = is -> 7;
        IOFunction<Integer, Integer> squareInteger = i -> i * i;
        IOFunction<InputStream, Integer> productFunction = squareInteger.compose(alwaysSeven);
        ByteArrayInputStream is2 = new ByteArrayInputStream(new byte[]{2, 3});
        Assertions.assertEquals((int)49, (Integer)productFunction.apply(is2));
        Assertions.assertEquals((int)49, (Integer)productFunction.apply(is2));
    }

    @Test
    public void testComposeIOFunction() throws IOException {
        IOFunction<InputStream, Integer> readByte = InputStream::read;
        IOFunction<Integer, Integer> squareInteger = i -> i * i;
        IOFunction<InputStream, Integer> productFunction = squareInteger.compose(readByte);
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{2, 3});
        Assertions.assertEquals((int)4, (Integer)productFunction.apply(is));
        Assertions.assertEquals((int)9, (Integer)productFunction.apply(is));
    }

    @Test
    public void testComposeIOSupplier() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{2, 3});
        IOSupplier<Integer> readByte = is::read;
        IOFunction<Integer, Integer> squareInteger = i -> i * i;
        IOSupplier<Integer> productFunction = squareInteger.compose(readByte);
        Assertions.assertEquals((int)4, (Integer)productFunction.get());
        Assertions.assertEquals((int)9, (Integer)productFunction.get());
    }

    @Test
    public void testComposeSupplier() throws IOException {
        Supplier<Integer> alwaysNine = () -> 9;
        IOFunction<Integer, Integer> squareInteger = i -> i * i;
        IOSupplier<Integer> productFunction = squareInteger.compose(alwaysNine);
        Assertions.assertEquals((int)81, (Integer)productFunction.get());
        Assertions.assertEquals((int)81, (Integer)productFunction.get());
    }

    @Test
    public void testIdentity() throws IOException {
        Assertions.assertEquals(IOFunction.identity(), IOFunction.identity());
        IOFunction<byte[], byte[]> identityFunction = IOFunction.identity();
        byte[] buf = new byte[]{10, 11, 12};
        Assertions.assertEquals((Object)buf, identityFunction.apply(buf));
        Assertions.assertArrayEquals((byte[])buf, (byte[])((byte[])identityFunction.apply(buf)));
    }

    private static final class Holder<T> {
        T value;

        private Holder() {
        }
    }
}

