/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.TempDirectory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathUtilsIsEmptyTest {
    public static final Path DIR_SIZE_1 = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]);
    private static final Path FILE_SIZE_0 = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0/file-size-0.bin", new String[0]);
    private static final Path FILE_SIZE_1 = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]);

    @Test
    public void testIsEmpty() throws IOException {
        Assertions.assertTrue((boolean)PathUtils.isEmpty(FILE_SIZE_0));
        Assertions.assertFalse((boolean)PathUtils.isEmpty(FILE_SIZE_1));
        try (TempDirectory tempDir = TempDirectory.create(this.getClass().getCanonicalName(), new FileAttribute[0]);){
            Assertions.assertTrue((boolean)PathUtils.isEmpty(tempDir.get()));
        }
        Assertions.assertFalse((boolean)PathUtils.isEmpty(DIR_SIZE_1));
    }

    @Test
    public void testIsEmptyDirectory() throws IOException {
        try (TempDirectory tempDir = TempDirectory.create(this.getClass().getCanonicalName(), new FileAttribute[0]);){
            Assertions.assertTrue((boolean)PathUtils.isEmptyDirectory(tempDir.get()));
        }
        Assertions.assertFalse((boolean)PathUtils.isEmptyDirectory(DIR_SIZE_1));
    }

    @Test
    public void testisEmptyFile() throws IOException {
        Assertions.assertTrue((boolean)PathUtils.isEmptyFile(FILE_SIZE_0));
        Assertions.assertFalse((boolean)PathUtils.isEmptyFile(FILE_SIZE_1));
    }
}

