/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.FilesUncheck;
import org.apache.commons.io.file.NoopPathVisitor;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.function.Uncheck;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FilesUncheckTest {
    private static final FileAttribute<?>[] EMPTY_FILE_ATTRIBUTES_ARRAY = new FileAttribute[0];
    private static final Path FILE_PATH_A = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]);
    private static final Path FILE_PATH_EMPTY = Paths.get("src/test/resources/org/apache/commons/io/test-file-empty.bin", new String[0]);
    private static final Path NEW_DIR_PATH = Paths.get("target/newdir", new String[0]);
    private static final Path NEW_FILE_PATH = Paths.get("target/file.txt", new String[0]);
    private static final Path NEW_FILE_PATH_LINK = Paths.get("target/to_another_file.txt", new String[0]);
    private static final String PREFIX = "prefix";
    private static final String SUFFIX = "suffix";
    private static final Path TARGET_PATH = Paths.get("target", new String[0]);

    @BeforeEach
    @AfterEach
    public void deleteFixtures() throws IOException {
        Files.deleteIfExists(NEW_FILE_PATH);
        Files.deleteIfExists(NEW_DIR_PATH);
        Files.deleteIfExists(NEW_FILE_PATH_LINK);
    }

    @Test
    public void testCopyInputStreamPathCopyOptionArray() {
        Assertions.assertEquals((long)0L, (long)FilesUncheck.copy(new NullInputStream(), NEW_FILE_PATH, PathUtils.EMPTY_COPY_OPTIONS));
    }

    @Test
    public void testCopyPathOutputStream() {
        Assertions.assertEquals((long)0L, (long)FilesUncheck.copy(FILE_PATH_EMPTY, NullOutputStream.INSTANCE));
    }

    @Test
    public void testCopyPathPathCopyOptionArray() {
        Assertions.assertEquals((Object)NEW_FILE_PATH, (Object)FilesUncheck.copy(FILE_PATH_EMPTY, NEW_FILE_PATH, PathUtils.EMPTY_COPY_OPTIONS));
    }

    @Test
    public void testCreateDirectories() {
        Assertions.assertEquals((Object)TARGET_PATH, (Object)FilesUncheck.createDirectories(TARGET_PATH, EMPTY_FILE_ATTRIBUTES_ARRAY));
    }

    @Test
    public void testCreateDirectory() {
        Assertions.assertEquals((Object)NEW_DIR_PATH, (Object)FilesUncheck.createDirectory(NEW_DIR_PATH, EMPTY_FILE_ATTRIBUTES_ARRAY));
    }

    @Test
    public void testCreateFile() {
        Assertions.assertEquals((Object)NEW_FILE_PATH, (Object)FilesUncheck.createFile(NEW_FILE_PATH, EMPTY_FILE_ATTRIBUTES_ARRAY));
    }

    @Test
    public void testCreateLink() {
        Assertions.assertEquals((Object)NEW_FILE_PATH_LINK, (Object)FilesUncheck.createLink(NEW_FILE_PATH_LINK, FILE_PATH_EMPTY));
    }

    @Test
    public void testCreateSymbolicLink() {
        Assertions.assertEquals((Object)NEW_FILE_PATH_LINK, (Object)FilesUncheck.createSymbolicLink(NEW_FILE_PATH_LINK, FILE_PATH_EMPTY, new FileAttribute[0]));
    }

    @Test
    public void testCreateTempDirectoryPathStringFileAttributeOfQArray() {
        Assertions.assertEquals((Object)TARGET_PATH, (Object)FilesUncheck.createTempDirectory(TARGET_PATH, PREFIX, EMPTY_FILE_ATTRIBUTES_ARRAY).getParent());
    }

    @Test
    public void testCreateTempDirectoryStringFileAttributeOfQArray() {
        Assertions.assertEquals((Object)PathUtils.getTempDirectory(), (Object)FilesUncheck.createTempDirectory(PREFIX, EMPTY_FILE_ATTRIBUTES_ARRAY).getParent());
    }

    @Test
    public void testCreateTempFilePathStringStringFileAttributeOfQArray() {
        Assertions.assertEquals((Object)TARGET_PATH, (Object)FilesUncheck.createTempFile(TARGET_PATH, PREFIX, SUFFIX, EMPTY_FILE_ATTRIBUTES_ARRAY).getParent());
    }

    @Test
    public void testCreateTempFileStringStringFileAttributeOfQArray() {
        Assertions.assertEquals((Object)PathUtils.getTempDirectory(), (Object)FilesUncheck.createTempFile(PREFIX, SUFFIX, EMPTY_FILE_ATTRIBUTES_ARRAY).getParent());
    }

    @Test
    public void testDelete() {
        Assertions.assertThrows(UncheckedIOException.class, () -> FilesUncheck.delete(NEW_FILE_PATH));
    }

    @Test
    public void testDeleteIfExists() {
        Assertions.assertFalse((boolean)FilesUncheck.deleteIfExists(NEW_FILE_PATH));
    }

    @Test
    public void testFind() {
        try (Stream<Path> find = FilesUncheck.find(FILE_PATH_EMPTY, 0, (t2, u) -> false, new FileVisitOption[0]);){
            Assertions.assertNotNull(find);
        }
    }

    @Test
    public void testGetAttribute() {
        Assertions.assertEquals((Object)0L, (Object)FilesUncheck.getAttribute(FILE_PATH_EMPTY, "basic:size", LinkOption.NOFOLLOW_LINKS));
    }

    @Test
    public void testGetFileStore() {
        Assertions.assertNotNull((Object)FilesUncheck.getFileStore(FILE_PATH_EMPTY));
    }

    @Test
    public void testGetLastModifiedTime() {
        Assertions.assertTrue((0L < FilesUncheck.getLastModifiedTime(FILE_PATH_EMPTY, LinkOption.NOFOLLOW_LINKS).toMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testGetOwner() {
        Assertions.assertNotNull((Object)FilesUncheck.getOwner(FILE_PATH_EMPTY, LinkOption.NOFOLLOW_LINKS));
    }

    @Test
    public void testGetPosixFilePermissions() {
        Assumptions.assumeTrue((boolean)PathUtils.isPosix(FILE_PATH_EMPTY, LinkOption.NOFOLLOW_LINKS));
        Assertions.assertNotNull(FilesUncheck.getPosixFilePermissions(FILE_PATH_EMPTY, LinkOption.NOFOLLOW_LINKS));
    }

    @Test
    public void testIsHidden() {
        Assertions.assertFalse((boolean)FilesUncheck.isHidden(FILE_PATH_EMPTY));
    }

    @Test
    public void testIsSameFile() {
        Assertions.assertTrue((boolean)FilesUncheck.isSameFile(FILE_PATH_EMPTY, FILE_PATH_EMPTY));
    }

    @Test
    public void testLinesPath() {
        try (Stream<String> stream = FilesUncheck.lines(FILE_PATH_EMPTY);){
            Assertions.assertEquals((long)0L, (long)stream.count());
        }
    }

    @Test
    public void testLinesPathCharset() {
        try (Stream<String> stream = FilesUncheck.lines(FILE_PATH_EMPTY, StandardCharsets.UTF_8);){
            Assertions.assertEquals((long)0L, (long)stream.count());
        }
    }

    @Test
    public void testList() {
        try (Stream<Path> stream = FilesUncheck.list(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]));){
            Assertions.assertEquals((long)1L, (long)stream.count());
        }
    }

    @Test
    public void testMove() {
        Path tempFile1 = FilesUncheck.createTempFile(PREFIX, SUFFIX, new FileAttribute[0]);
        Path tempFile2 = FilesUncheck.createTempFile(PREFIX, SUFFIX, new FileAttribute[0]);
        Assertions.assertEquals((Object)tempFile2, (Object)FilesUncheck.move(tempFile1, tempFile2, StandardCopyOption.REPLACE_EXISTING));
        FilesUncheck.delete(tempFile2);
    }

    @Test
    public void testNewBufferedReaderPath() {
        Uncheck.run(() -> {
            try (BufferedReader reader = FilesUncheck.newBufferedReader(FILE_PATH_EMPTY);){
                IOUtils.consume(reader);
            }
        });
    }

    @Test
    public void testNewBufferedReaderPathCharset() {
        Uncheck.run(() -> {
            try (BufferedReader reader = FilesUncheck.newBufferedReader(FILE_PATH_EMPTY, StandardCharsets.UTF_8);){
                IOUtils.consume(reader);
            }
        });
    }

    @Test
    public void testNewBufferedWriterPathCharsetOpenOptionArray() {
        Path tempPath = FilesUncheck.createTempFile(PREFIX, SUFFIX, new FileAttribute[0]);
        Uncheck.run(() -> {
            try (BufferedWriter writer = FilesUncheck.newBufferedWriter(tempPath, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);){
                writer.append("test");
            }
        });
        Assertions.assertEquals((Object)"test", (Object)FilesUncheck.readAllLines(tempPath, StandardCharsets.UTF_8).get(0));
    }

    @Test
    public void testNewBufferedWriterPathOpenOptionArray() {
        Path tempPath = FilesUncheck.createTempFile(PREFIX, SUFFIX, new FileAttribute[0]);
        Uncheck.run(() -> {
            try (BufferedWriter writer = FilesUncheck.newBufferedWriter(tempPath, StandardOpenOption.TRUNCATE_EXISTING);){
                writer.append("test");
            }
        });
        Assertions.assertEquals((Object)"test", (Object)FilesUncheck.readAllLines(tempPath).get(0));
    }

    @Test
    public void testNewByteChannelPathOpenOptionArray() {
        Assertions.assertEquals((long)0L, (Long)Uncheck.get(() -> {
            try (SeekableByteChannel c = FilesUncheck.newByteChannel(FILE_PATH_EMPTY, StandardOpenOption.READ);){
                Long l = c.size();
                return l;
            }
        }));
    }

    @Test
    public void testNewByteChannelPathSetOfQextendsOpenOptionFileAttributeOfQArray() {
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        options.add(StandardOpenOption.READ);
        Assertions.assertEquals((long)0L, (Long)Uncheck.get(() -> {
            try (SeekableByteChannel c = FilesUncheck.newByteChannel(FILE_PATH_EMPTY, options, EMPTY_FILE_ATTRIBUTES_ARRAY);){
                Long l = c.size();
                return l;
            }
        }));
    }

    @Test
    public void testNewDirectoryStreamPath() {
        Uncheck.run(() -> {
            try (DirectoryStream<Path> directoryStream = FilesUncheck.newDirectoryStream(TARGET_PATH);){
                directoryStream.forEach(e -> Assertions.assertEquals((Object)TARGET_PATH, (Object)e.getParent()));
            }
        });
    }

    @Test
    public void testNewDirectoryStreamPathFilterOfQsuperPath() {
        Uncheck.run(() -> {
            try (DirectoryStream<Path> directoryStream = FilesUncheck.newDirectoryStream(TARGET_PATH, e -> true);){
                directoryStream.forEach(e -> Assertions.assertEquals((Object)TARGET_PATH, (Object)e.getParent()));
            }
        });
    }

    @Test
    public void testNewDirectoryStreamPathString() {
        Uncheck.run(() -> {
            try (DirectoryStream<Path> directoryStream = FilesUncheck.newDirectoryStream(TARGET_PATH, "*.xml");){
                directoryStream.forEach(e -> Assertions.assertEquals((Object)TARGET_PATH, (Object)e.getParent()));
            }
        });
    }

    @Test
    public void testNewInputStream() {
        Assertions.assertEquals((int)0, (Integer)Uncheck.get(() -> {
            try (InputStream in = FilesUncheck.newInputStream(FILE_PATH_EMPTY, StandardOpenOption.READ);){
                Integer n = in.available();
                return n;
            }
        }));
    }

    @Test
    public void testNewOutputStream() {
        Path tempPath = FilesUncheck.createTempFile(PREFIX, SUFFIX, new FileAttribute[0]);
        Uncheck.run(() -> {
            try (OutputStream stream = FilesUncheck.newOutputStream(tempPath, StandardOpenOption.TRUNCATE_EXISTING);){
                stream.write("test".getBytes());
            }
        });
        Assertions.assertEquals((Object)"test", (Object)FilesUncheck.readAllLines(tempPath).get(0));
    }

    @Test
    public void testProbeContentType() {
        String probeContentType = FilesUncheck.probeContentType(FILE_PATH_EMPTY);
        probeContentType = FilesUncheck.probeContentType(Paths.get("src/test/resources/org/apache/commons/io/testfileBOM.xml", new String[0]));
    }

    @Test
    public void testReadAllBytes() {
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])FilesUncheck.readAllBytes(FILE_PATH_EMPTY));
        Assertions.assertArrayEquals((byte[])new byte[]{97}, (byte[])FilesUncheck.readAllBytes(FILE_PATH_A));
    }

    @Test
    public void testReadAllLinesPath() {
        Assertions.assertEquals(Collections.emptyList(), FilesUncheck.readAllLines(FILE_PATH_EMPTY));
        Assertions.assertEquals(Arrays.asList("a"), FilesUncheck.readAllLines(FILE_PATH_A));
    }

    @Test
    public void testReadAllLinesPathCharset() {
        Assertions.assertEquals(Collections.emptyList(), FilesUncheck.readAllLines(FILE_PATH_EMPTY, StandardCharsets.UTF_8));
        Assertions.assertEquals(Arrays.asList("a"), FilesUncheck.readAllLines(FILE_PATH_A, StandardCharsets.UTF_8));
    }

    @Test
    public void testReadAttributesPathClassOfALinkOptionArray() {
        Assertions.assertNotNull((Object)FilesUncheck.readAttributes(FILE_PATH_EMPTY, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS));
    }

    @Test
    public void testReadAttributesPathStringLinkOptionArray() {
        Assertions.assertNotNull(FilesUncheck.readAttributes(FILE_PATH_EMPTY, "basic:lastModifiedTime", LinkOption.NOFOLLOW_LINKS));
    }

    @Test
    public void testReadSymbolicLink() {
        Assertions.assertThrows(UncheckedIOException.class, () -> FilesUncheck.readSymbolicLink(NEW_FILE_PATH_LINK));
    }

    @Test
    public void testSetAttribute() {
        FileTime ft = FilesUncheck.getLastModifiedTime(FILE_PATH_EMPTY, new LinkOption[0]);
        Assertions.assertEquals((Object)FILE_PATH_EMPTY, (Object)FilesUncheck.setAttribute(FILE_PATH_EMPTY, "basic:lastModifiedTime", ft, LinkOption.NOFOLLOW_LINKS));
    }

    @Test
    public void testSetLastModifiedTime() {
        FileTime ft = FilesUncheck.getLastModifiedTime(FILE_PATH_EMPTY, new LinkOption[0]);
        Assertions.assertEquals((Object)FILE_PATH_EMPTY, (Object)FilesUncheck.setLastModifiedTime(FILE_PATH_EMPTY, ft));
    }

    @Test
    public void testSetOwner() {
        UserPrincipal owner = FilesUncheck.getOwner(FILE_PATH_EMPTY, LinkOption.NOFOLLOW_LINKS);
        Assertions.assertEquals((Object)FILE_PATH_EMPTY, (Object)FilesUncheck.setOwner(FILE_PATH_EMPTY, owner));
    }

    @Test
    public void testSetPosixFilePermissions() {
        Assumptions.assumeTrue((boolean)PathUtils.isPosix(FILE_PATH_EMPTY, LinkOption.NOFOLLOW_LINKS));
        Set<PosixFilePermission> posixFilePermissions = FilesUncheck.getPosixFilePermissions(FILE_PATH_EMPTY, LinkOption.NOFOLLOW_LINKS);
        Assertions.assertEquals((Object)FILE_PATH_EMPTY, (Object)FilesUncheck.setPosixFilePermissions(FILE_PATH_EMPTY, posixFilePermissions));
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((long)0L, (long)FilesUncheck.size(FILE_PATH_EMPTY));
        Assertions.assertEquals((long)1L, (long)FilesUncheck.size(FILE_PATH_A));
    }

    @Test
    public void testWalkFileTreePathFileVisitorOfQsuperPath() {
        Assertions.assertEquals((Object)TARGET_PATH, (Object)FilesUncheck.walkFileTree(TARGET_PATH, NoopPathVisitor.INSTANCE));
    }

    @Test
    public void testWalkFileTreePathSetOfFileVisitOptionIntFileVisitorOfQsuperPath() {
        Assertions.assertEquals((Object)TARGET_PATH, (Object)FilesUncheck.walkFileTree(TARGET_PATH, new HashSet<FileVisitOption>(), 1, NoopPathVisitor.INSTANCE));
    }

    @Test
    public void testWalkPathFileVisitOptionArray() {
        try (Stream<Path> stream = FilesUncheck.walk(TARGET_PATH, FileVisitOption.FOLLOW_LINKS);){
            Assertions.assertTrue((0L < stream.count() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWalkPathIntFileVisitOptionArray() {
        try (Stream<Path> stream = FilesUncheck.walk(TARGET_PATH, 0, FileVisitOption.FOLLOW_LINKS);){
            Assertions.assertEquals((long)1L, (long)stream.count());
        }
    }

    @Test
    public void testWritePathByteArrayOpenOptionArray() {
        Path tempFile = FilesUncheck.createTempFile(PREFIX, SUFFIX, new FileAttribute[0]);
        Assertions.assertEquals((Object)tempFile, (Object)FilesUncheck.write(tempFile, "test".getBytes(), StandardOpenOption.TRUNCATE_EXISTING));
        FilesUncheck.delete(tempFile);
    }

    @Test
    public void testWritePathIterableOfQextendsCharSequenceCharsetOpenOptionArray() {
        Path tempFile = FilesUncheck.createTempFile(PREFIX, SUFFIX, new FileAttribute[0]);
        Assertions.assertEquals((Object)tempFile, (Object)FilesUncheck.write(tempFile, Arrays.asList("test"), StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING));
        FilesUncheck.delete(tempFile);
    }

    @Test
    public void testWritePathIterableOfQextendsCharSequenceOpenOptionArray() {
        Path tempFile = FilesUncheck.createTempFile(PREFIX, SUFFIX, new FileAttribute[0]);
        Assertions.assertEquals((Object)tempFile, (Object)FilesUncheck.write(tempFile, Arrays.asList("test"), StandardOpenOption.TRUNCATE_EXISTING));
        FilesUncheck.delete(tempFile);
    }
}

