/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.RandomAccessFiles;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class RandomAccessFilesTest {
    private static final Path PATH_RO_20 = Paths.get("src/test/resources/org/apache/commons/io/test-file-20byteslength.bin", new String[0]);
    private static final Path PATH_RO_0 = Paths.get("src/test/resources/org/apache/commons/io/test-file-empty.bin", new String[0]);
    private static final Path PATH_RO_0_BIS = Paths.get("src/test/resources/org/apache/commons/io/test-file-empty2.bin", new String[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=RandomAccessFileMode.class)
    public void testContentEquals(RandomAccessFileMode mode) throws IOException {
        RandomAccessFile raf2;
        mode.accept(PATH_RO_20, raf -> {
            Assertions.assertEquals((Object)raf, (Object)raf);
            Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals(raf, raf));
        });
        mode.accept(PATH_RO_20, raf -> {
            Assertions.assertEquals((Object)raf, (Object)raf);
            Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals(raf, raf));
        });
        try (RandomAccessFile raf12 = mode.create(PATH_RO_20);){
            raf2 = mode.create(PATH_RO_20);
            try {
                Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals(raf12, raf2));
            }
            finally {
                if (raf2 != null) {
                    raf2.close();
                }
            }
        }
        mode.accept(PATH_RO_20, raf1 -> mode.accept(PATH_RO_20, raf2 -> Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals(raf1, raf2))));
        raf12 = mode.create(PATH_RO_0);
        try {
            raf2 = mode.create(PATH_RO_0);
            try {
                Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals(raf12, raf2));
                Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals(RandomAccessFiles.reset(raf2), RandomAccessFiles.reset(raf12)));
            }
            finally {
                if (raf2 != null) {
                    raf2.close();
                }
            }
        }
        finally {
            if (raf12 != null) {
                raf12.close();
            }
        }
        raf12 = mode.create(PATH_RO_0);
        try {
            raf2 = mode.create(PATH_RO_0_BIS);
            try {
                Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals(raf12, raf2));
                Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals(RandomAccessFiles.reset(raf2), RandomAccessFiles.reset(raf12)));
            }
            finally {
                if (raf2 != null) {
                    raf2.close();
                }
            }
        }
        finally {
            if (raf12 != null) {
                raf12.close();
            }
        }
        raf12 = mode.create(PATH_RO_0);
        try {
            raf2 = mode.create(PATH_RO_20);
            try {
                Assertions.assertFalse((boolean)RandomAccessFiles.contentEquals(raf12, raf2));
                Assertions.assertFalse((boolean)RandomAccessFiles.contentEquals(RandomAccessFiles.reset(raf2), RandomAccessFiles.reset(raf12)));
            }
            finally {
                if (raf2 != null) {
                    raf2.close();
                }
            }
        }
        finally {
            if (raf12 != null) {
                raf12.close();
            }
        }
        Path bigFile1 = Files.createTempFile(this.getClass().getSimpleName(), "-1.bin", new FileAttribute[0]);
        Path bigFile2 = Files.createTempFile(this.getClass().getSimpleName(), "-2.bin", new FileAttribute[0]);
        Path bigFile3 = Files.createTempFile(this.getClass().getSimpleName(), "-3.bin", new FileAttribute[0]);
        try {
            int newLength = 1000000;
            byte[] bytes1 = new byte[1000000];
            byte[] bytes2 = new byte[1000000];
            Arrays.fill(bytes1, (byte)1);
            Arrays.fill(bytes2, (byte)2);
            Files.write(bigFile1, bytes1, new OpenOption[0]);
            Files.write(bigFile2, bytes2, new OpenOption[0]);
            try (RandomAccessFile raf13 = mode.create(bigFile1);
                 RandomAccessFile raf22 = mode.create(bigFile2);){
                Assertions.assertFalse((boolean)RandomAccessFiles.contentEquals(raf13, raf22));
                Assertions.assertFalse((boolean)RandomAccessFiles.contentEquals(RandomAccessFiles.reset(raf22), RandomAccessFiles.reset(raf13)));
                Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals(RandomAccessFiles.reset(raf13), RandomAccessFiles.reset(raf13)));
            }
            byte[] bytes3 = (byte[])bytes1.clone();
            bytes3[bytes3.length - 1] = 9;
            Files.write(bigFile3, bytes3, new OpenOption[0]);
            try (RandomAccessFile raf14 = mode.create(bigFile1);
                 RandomAccessFile raf3 = mode.create(bigFile3);){
                Assertions.assertFalse((boolean)RandomAccessFiles.contentEquals(raf14, raf3));
                Assertions.assertFalse((boolean)RandomAccessFiles.contentEquals(RandomAccessFiles.reset(raf3), RandomAccessFiles.reset(raf14)));
            }
        }
        finally {
            Files.deleteIfExists(bigFile1);
            Files.deleteIfExists(bigFile2);
            Files.deleteIfExists(bigFile3);
        }
    }

    @ParameterizedTest
    @EnumSource(value=RandomAccessFileMode.class)
    public void testRead(RandomAccessFileMode mode) throws IOException {
        mode.accept(PATH_RO_20, raf -> Assertions.assertArrayEquals((byte[])new byte[0], (byte[])RandomAccessFiles.read(raf, 0L, 0)));
        mode.accept(PATH_RO_20, raf -> Assertions.assertArrayEquals((byte[])new byte[0], (byte[])RandomAccessFiles.read(raf, 1L, 0)));
        mode.accept(PATH_RO_20, raf -> Assertions.assertArrayEquals((byte[])new byte[]{49}, (byte[])RandomAccessFiles.read(raf, 0L, 1)));
        mode.accept(PATH_RO_20, raf -> Assertions.assertArrayEquals((byte[])new byte[]{50}, (byte[])RandomAccessFiles.read(raf, 1L, 1)));
        mode.accept(PATH_RO_20, raf -> Assertions.assertEquals((int)20, (int)RandomAccessFiles.read(raf, 0L, 20).length));
        mode.accept(PATH_RO_20, raf -> Assertions.assertThrows(IOException.class, () -> RandomAccessFiles.read(raf, 0L, 21)));
    }
}

