/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileUtilsDirectoryContainsTest {
    private File directory1;
    private File directory2;
    private File directory3;
    private File file1;
    private File file1ByRelativeDirectory2;
    private File file2;
    private File file2ByRelativeDirectory1;
    private File file3;
    @TempDir
    public File top;

    @BeforeEach
    public void setUp() throws Exception {
        this.directory1 = new File(this.top, "directory1");
        this.directory2 = new File(this.top, "directory2");
        this.directory3 = new File(this.directory2, "directory3");
        this.directory1.mkdir();
        this.directory2.mkdir();
        this.directory3.mkdir();
        this.file1 = new File(this.directory1, "file1");
        this.file2 = new File(this.directory2, "file2");
        this.file3 = new File(this.top, "file3");
        this.file1ByRelativeDirectory2 = new File(this.top, "directory2/../directory1/file1");
        this.file2ByRelativeDirectory1 = new File(this.top, "directory1/../directory2/file2");
        FileUtils.touch(this.file1);
        FileUtils.touch(this.file2);
        FileUtils.touch(this.file3);
    }

    @Test
    public void testCanonicalPath() throws IOException {
        Assertions.assertTrue((boolean)FileUtils.directoryContains(this.directory1, this.file1ByRelativeDirectory2));
        Assertions.assertTrue((boolean)FileUtils.directoryContains(this.directory2, this.file2ByRelativeDirectory1));
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.directory1, this.file2ByRelativeDirectory1));
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.directory2, this.file1ByRelativeDirectory2));
    }

    @Test
    public void testDirectoryContainsDirectory() throws IOException {
        Assertions.assertTrue((boolean)FileUtils.directoryContains(this.top, this.directory1));
        Assertions.assertTrue((boolean)FileUtils.directoryContains(this.top, this.directory2));
        Assertions.assertTrue((boolean)FileUtils.directoryContains(this.top, this.directory3));
        Assertions.assertTrue((boolean)FileUtils.directoryContains(this.directory2, this.directory3));
    }

    @Test
    public void testDirectoryContainsFile() throws IOException {
        Assertions.assertTrue((boolean)FileUtils.directoryContains(this.directory1, this.file1));
        Assertions.assertTrue((boolean)FileUtils.directoryContains(this.directory2, this.file2));
    }

    @Test
    public void testDirectoryDoesNotContainFile() throws IOException {
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.directory1, this.file2));
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.directory2, this.file1));
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.directory1, this.file3));
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.directory2, this.file3));
    }

    @Test
    public void testDirectoryDoesNotContainsDirectory() throws IOException {
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.directory1, this.top));
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.directory2, this.top));
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.directory3, this.top));
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.directory3, this.directory2));
    }

    @Test
    public void testDirectoryDoesNotExist() {
        File dir = new File("DOESNOTEXIST");
        Assertions.assertFalse((boolean)dir.exists());
        Assertions.assertThrows(FileNotFoundException.class, () -> FileUtils.directoryContains(dir, this.file1));
    }

    @Test
    public void testFileDoesNotExist() throws IOException {
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.top, null));
        File file = new File("DOESNOTEXIST");
        Assertions.assertFalse((boolean)file.exists());
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.top, file));
    }

    @Test
    public void testFileDoesNotExistBug() throws IOException {
        File file = new File(this.top, "DOESNOTEXIST");
        Assertions.assertTrue((boolean)this.top.exists(), (String)"Check directory exists");
        Assertions.assertFalse((boolean)file.exists(), (String)"Check file does not exist");
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.top, file), (String)"Directory does not contain unrealized file");
    }

    @Test
    public void testFileHavingSamePrefixBug() throws IOException {
        File foo = new File(this.top, "foo");
        File foobar = new File(this.top, "foobar");
        File fooTxt = new File(this.top, "foo.txt");
        foo.mkdir();
        foobar.mkdir();
        FileUtils.touch(fooTxt);
        Assertions.assertFalse((boolean)FileUtils.directoryContains(foo, foobar));
        Assertions.assertFalse((boolean)FileUtils.directoryContains(foo, fooTxt));
    }

    @Test
    public void testIO466() throws IOException {
        File fooFile = new File(this.directory1.getParent(), "directory1.txt");
        Assertions.assertFalse((boolean)FileUtils.directoryContains(this.directory1, fooFile));
    }

    @Test
    public void testSameFile() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.directoryContains(this.file1, this.file1));
    }

    @Test
    public void testUnrealizedContainment() {
        File dir = new File("DOESNOTEXIST");
        File file = new File(dir, "DOESNOTEXIST2");
        Assertions.assertFalse((boolean)dir.exists());
        Assertions.assertFalse((boolean)file.exists());
        Assertions.assertThrows(FileNotFoundException.class, () -> FileUtils.directoryContains(dir, file));
    }
}

