package org.openqa.selenium.devtools.v133.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class AttributionReportingFilterConfig {

    private final java.util.List<org.openqa.selenium.devtools.v133.storage.model.AttributionReportingFilterDataEntry> filterValues;

    private final java.util.Optional<java.lang.Integer> lookbackWindow;

    public AttributionReportingFilterConfig(java.util.List<org.openqa.selenium.devtools.v133.storage.model.AttributionReportingFilterDataEntry> filterValues, java.util.Optional<java.lang.Integer> lookbackWindow) {
        this.filterValues = java.util.Objects.requireNonNull(filterValues, "filterValues is required");
        this.lookbackWindow = lookbackWindow;
    }

    public java.util.List<org.openqa.selenium.devtools.v133.storage.model.AttributionReportingFilterDataEntry> getFilterValues() {
        return filterValues;
    }

    /**
     * duration in seconds
     */
    public java.util.Optional<java.lang.Integer> getLookbackWindow() {
        return lookbackWindow;
    }

    private static AttributionReportingFilterConfig fromJson(JsonInput input) {
        java.util.List<org.openqa.selenium.devtools.v133.storage.model.AttributionReportingFilterDataEntry> filterValues = null;
        java.util.Optional<java.lang.Integer> lookbackWindow = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "filterValues":
                    filterValues = input.readArray(org.openqa.selenium.devtools.v133.storage.model.AttributionReportingFilterDataEntry.class);
                    break;
                case "lookbackWindow":
                    lookbackWindow = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AttributionReportingFilterConfig(filterValues, lookbackWindow);
    }
}
