package org.openqa.selenium.devtools.v133.profiler;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

public class Profiler {

    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Profiler.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Profiler.enable", Map.copyOf(params));
    }

    /**
     * Collect coverage data for the current isolate. The coverage data may be incomplete due to
     * garbage collection.
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v133.profiler.model.ScriptCoverage>> getBestEffortCoverage() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Profiler.getBestEffortCoverage", Map.copyOf(params), ConverterFunctions.map("result", input -> input.readArray(org.openqa.selenium.devtools.v133.profiler.model.ScriptCoverage.class)));
    }

    /**
     * Changes CPU profiler sampling interval. Must be called before CPU profiles recording started.
     */
    public static Command<Void> setSamplingInterval(java.lang.Integer interval) {
        java.util.Objects.requireNonNull(interval, "interval is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("interval", interval);
        return new Command<>("Profiler.setSamplingInterval", Map.copyOf(params));
    }

    public static Command<Void> start() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Profiler.start", Map.copyOf(params));
    }

    /**
     * Enable precise code coverage. Coverage data for JavaScript executed before enabling precise code
     * coverage may be incomplete. Enabling prevents running optimized code and resets execution
     * counters.
     */
    public static Command<java.lang.Number> startPreciseCoverage(java.util.Optional<java.lang.Boolean> callCount, java.util.Optional<java.lang.Boolean> detailed, java.util.Optional<java.lang.Boolean> allowTriggeredUpdates) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        callCount.ifPresent(p -> params.put("callCount", p));
        detailed.ifPresent(p -> params.put("detailed", p));
        allowTriggeredUpdates.ifPresent(p -> params.put("allowTriggeredUpdates", p));
        return new Command<>("Profiler.startPreciseCoverage", Map.copyOf(params), ConverterFunctions.map("timestamp", java.lang.Number.class));
    }

    public static Command<org.openqa.selenium.devtools.v133.profiler.model.Profile> stop() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Profiler.stop", Map.copyOf(params), ConverterFunctions.map("profile", org.openqa.selenium.devtools.v133.profiler.model.Profile.class));
    }

    /**
     * Disable precise code coverage. Disabling releases unnecessary execution count records and allows
     * executing optimized code.
     */
    public static Command<Void> stopPreciseCoverage() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Profiler.stopPreciseCoverage", Map.copyOf(params));
    }

    public static class TakePreciseCoverageResponse {

        private final java.util.List<org.openqa.selenium.devtools.v133.profiler.model.ScriptCoverage> result;

        private final java.lang.Number timestamp;

        public TakePreciseCoverageResponse(java.util.List<org.openqa.selenium.devtools.v133.profiler.model.ScriptCoverage> result, java.lang.Number timestamp) {
            this.result = java.util.Objects.requireNonNull(result, "result is required");
            this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        }

        /**
         * Coverage data for the current isolate.
         */
        public java.util.List<org.openqa.selenium.devtools.v133.profiler.model.ScriptCoverage> getResult() {
            return result;
        }

        /**
         * Monotonically increasing time (in seconds) when the coverage update was taken in the backend.
         */
        public java.lang.Number getTimestamp() {
            return timestamp;
        }

        private static TakePreciseCoverageResponse fromJson(JsonInput input) {
            java.util.List<org.openqa.selenium.devtools.v133.profiler.model.ScriptCoverage> result = null;
            java.lang.Number timestamp = 0;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "result":
                        result = input.readArray(org.openqa.selenium.devtools.v133.profiler.model.ScriptCoverage.class);
                        break;
                    case "timestamp":
                        timestamp = input.nextNumber();
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new TakePreciseCoverageResponse(result, timestamp);
        }
    }

    /**
     * Collect coverage data for the current isolate, and resets execution counters. Precise code
     * coverage needs to have started.
     */
    public static Command<org.openqa.selenium.devtools.v133.profiler.Profiler.TakePreciseCoverageResponse> takePreciseCoverage() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Profiler.takePreciseCoverage", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v133.profiler.Profiler.TakePreciseCoverageResponse.class));
    }

    public static Event<org.openqa.selenium.devtools.v133.profiler.model.ConsoleProfileFinished> consoleProfileFinished() {
        return new Event<>("Profiler.consoleProfileFinished", input -> input.read(org.openqa.selenium.devtools.v133.profiler.model.ConsoleProfileFinished.class));
    }

    public static Event<org.openqa.selenium.devtools.v133.profiler.model.ConsoleProfileStarted> consoleProfileStarted() {
        return new Event<>("Profiler.consoleProfileStarted", input -> input.read(org.openqa.selenium.devtools.v133.profiler.model.ConsoleProfileStarted.class));
    }

    public static Event<org.openqa.selenium.devtools.v133.profiler.model.PreciseCoverageDeltaUpdate> preciseCoverageDeltaUpdate() {
        return new Event<>("Profiler.preciseCoverageDeltaUpdate", input -> input.read(org.openqa.selenium.devtools.v133.profiler.model.PreciseCoverageDeltaUpdate.class));
    }
}
