package org.openqa.selenium.devtools.v132.layertree.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Information about a compositing layer.
 */
public class Layer {

    private final org.openqa.selenium.devtools.v132.layertree.model.LayerId layerId;

    private final java.util.Optional<org.openqa.selenium.devtools.v132.layertree.model.LayerId> parentLayerId;

    private final java.util.Optional<org.openqa.selenium.devtools.v132.dom.model.BackendNodeId> backendNodeId;

    private final java.lang.Number offsetX;

    private final java.lang.Number offsetY;

    private final java.lang.Number width;

    private final java.lang.Number height;

    private final java.util.Optional<java.util.List<java.lang.Number>> transform;

    private final java.util.Optional<java.lang.Number> anchorX;

    private final java.util.Optional<java.lang.Number> anchorY;

    private final java.util.Optional<java.lang.Number> anchorZ;

    private final java.lang.Integer paintCount;

    private final java.lang.Boolean drawsContent;

    private final java.util.Optional<java.lang.Boolean> invisible;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v132.layertree.model.ScrollRect>> scrollRects;

    private final java.util.Optional<org.openqa.selenium.devtools.v132.layertree.model.StickyPositionConstraint> stickyPositionConstraint;

    public Layer(org.openqa.selenium.devtools.v132.layertree.model.LayerId layerId, java.util.Optional<org.openqa.selenium.devtools.v132.layertree.model.LayerId> parentLayerId, java.util.Optional<org.openqa.selenium.devtools.v132.dom.model.BackendNodeId> backendNodeId, java.lang.Number offsetX, java.lang.Number offsetY, java.lang.Number width, java.lang.Number height, java.util.Optional<java.util.List<java.lang.Number>> transform, java.util.Optional<java.lang.Number> anchorX, java.util.Optional<java.lang.Number> anchorY, java.util.Optional<java.lang.Number> anchorZ, java.lang.Integer paintCount, java.lang.Boolean drawsContent, java.util.Optional<java.lang.Boolean> invisible, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v132.layertree.model.ScrollRect>> scrollRects, java.util.Optional<org.openqa.selenium.devtools.v132.layertree.model.StickyPositionConstraint> stickyPositionConstraint) {
        this.layerId = java.util.Objects.requireNonNull(layerId, "layerId is required");
        this.parentLayerId = parentLayerId;
        this.backendNodeId = backendNodeId;
        this.offsetX = java.util.Objects.requireNonNull(offsetX, "offsetX is required");
        this.offsetY = java.util.Objects.requireNonNull(offsetY, "offsetY is required");
        this.width = java.util.Objects.requireNonNull(width, "width is required");
        this.height = java.util.Objects.requireNonNull(height, "height is required");
        this.transform = transform;
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        this.anchorZ = anchorZ;
        this.paintCount = java.util.Objects.requireNonNull(paintCount, "paintCount is required");
        this.drawsContent = java.util.Objects.requireNonNull(drawsContent, "drawsContent is required");
        this.invisible = invisible;
        this.scrollRects = scrollRects;
        this.stickyPositionConstraint = stickyPositionConstraint;
    }

    /**
     * The unique id for this layer.
     */
    public org.openqa.selenium.devtools.v132.layertree.model.LayerId getLayerId() {
        return layerId;
    }

    /**
     * The id of parent (not present for root).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v132.layertree.model.LayerId> getParentLayerId() {
        return parentLayerId;
    }

    /**
     * The backend id for the node associated with this layer.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v132.dom.model.BackendNodeId> getBackendNodeId() {
        return backendNodeId;
    }

    /**
     * Offset from parent layer, X coordinate.
     */
    public java.lang.Number getOffsetX() {
        return offsetX;
    }

    /**
     * Offset from parent layer, Y coordinate.
     */
    public java.lang.Number getOffsetY() {
        return offsetY;
    }

    /**
     * Layer width.
     */
    public java.lang.Number getWidth() {
        return width;
    }

    /**
     * Layer height.
     */
    public java.lang.Number getHeight() {
        return height;
    }

    /**
     * Transformation matrix for layer, default is identity matrix
     */
    public java.util.Optional<java.util.List<java.lang.Number>> getTransform() {
        return transform;
    }

    /**
     * Transform anchor point X, absent if no transform specified
     */
    public java.util.Optional<java.lang.Number> getAnchorX() {
        return anchorX;
    }

    /**
     * Transform anchor point Y, absent if no transform specified
     */
    public java.util.Optional<java.lang.Number> getAnchorY() {
        return anchorY;
    }

    /**
     * Transform anchor point Z, absent if no transform specified
     */
    public java.util.Optional<java.lang.Number> getAnchorZ() {
        return anchorZ;
    }

    /**
     * Indicates how many time this layer has painted.
     */
    public java.lang.Integer getPaintCount() {
        return paintCount;
    }

    /**
     * Indicates whether this layer hosts any content, rather than being used for
     * transform/scrolling purposes only.
     */
    public java.lang.Boolean getDrawsContent() {
        return drawsContent;
    }

    /**
     * Set if layer is not visible.
     */
    public java.util.Optional<java.lang.Boolean> getInvisible() {
        return invisible;
    }

    /**
     * Rectangles scrolling on main thread only.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v132.layertree.model.ScrollRect>> getScrollRects() {
        return scrollRects;
    }

    /**
     * Sticky position constraint information
     */
    public java.util.Optional<org.openqa.selenium.devtools.v132.layertree.model.StickyPositionConstraint> getStickyPositionConstraint() {
        return stickyPositionConstraint;
    }

    private static Layer fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v132.layertree.model.LayerId layerId = null;
        java.util.Optional<org.openqa.selenium.devtools.v132.layertree.model.LayerId> parentLayerId = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v132.dom.model.BackendNodeId> backendNodeId = java.util.Optional.empty();
        java.lang.Number offsetX = 0;
        java.lang.Number offsetY = 0;
        java.lang.Number width = 0;
        java.lang.Number height = 0;
        java.util.Optional<java.util.List<java.lang.Number>> transform = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> anchorX = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> anchorY = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> anchorZ = java.util.Optional.empty();
        java.lang.Integer paintCount = 0;
        java.lang.Boolean drawsContent = false;
        java.util.Optional<java.lang.Boolean> invisible = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v132.layertree.model.ScrollRect>> scrollRects = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v132.layertree.model.StickyPositionConstraint> stickyPositionConstraint = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "layerId":
                    layerId = input.read(org.openqa.selenium.devtools.v132.layertree.model.LayerId.class);
                    break;
                case "parentLayerId":
                    parentLayerId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v132.layertree.model.LayerId.class));
                    break;
                case "backendNodeId":
                    backendNodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v132.dom.model.BackendNodeId.class));
                    break;
                case "offsetX":
                    offsetX = input.nextNumber();
                    break;
                case "offsetY":
                    offsetY = input.nextNumber();
                    break;
                case "width":
                    width = input.nextNumber();
                    break;
                case "height":
                    height = input.nextNumber();
                    break;
                case "transform":
                    transform = java.util.Optional.ofNullable(input.readArray(java.lang.Number.class));
                    break;
                case "anchorX":
                    anchorX = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "anchorY":
                    anchorY = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "anchorZ":
                    anchorZ = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "paintCount":
                    paintCount = input.nextNumber().intValue();
                    break;
                case "drawsContent":
                    drawsContent = input.nextBoolean();
                    break;
                case "invisible":
                    invisible = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "scrollRects":
                    scrollRects = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v132.layertree.model.ScrollRect.class));
                    break;
                case "stickyPositionConstraint":
                    stickyPositionConstraint = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v132.layertree.model.StickyPositionConstraint.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Layer(layerId, parentLayerId, backendNodeId, offsetX, offsetY, width, height, transform, anchorX, anchorY, anchorZ, paintCount, drawsContent, invisible, scrollRects, stickyPositionConstraint);
    }
}
