package org.openqa.selenium.devtools.v131.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Enum of shared storage access types.
 */
public enum SharedStorageAccessType {

    DOCUMENTADDMODULE("documentAddModule"),
    DOCUMENTSELECTURL("documentSelectURL"),
    DOCUMENTRUN("documentRun"),
    DOCUMENTSET("documentSet"),
    DOCUMENTAPPEND("documentAppend"),
    DOCUMENTDELETE("documentDelete"),
    DOCUMENTCLEAR("documentClear"),
    DOCUMENTGET("documentGet"),
    WORKLETSET("workletSet"),
    WORKLETAPPEND("workletAppend"),
    WORKLETDELETE("workletDelete"),
    WORKLETCLEAR("workletClear"),
    WORKLETGET("workletGet"),
    WORKLETKEYS("workletKeys"),
    WORKLETENTRIES("workletEntries"),
    WORKLETLENGTH("workletLength"),
    WORKLETREMAININGBUDGET("workletRemainingBudget"),
    HEADERSET("headerSet"),
    HEADERAPPEND("headerAppend"),
    HEADERDELETE("headerDelete"),
    HEADERCLEAR("headerClear");

    private String value;

    SharedStorageAccessType(String value) {
        this.value = value;
    }

    public static SharedStorageAccessType fromString(String s) {
        return java.util.Arrays.stream(SharedStorageAccessType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SharedStorageAccessType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static SharedStorageAccessType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
