/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.bidi.script.LocalValue;
import org.openqa.selenium.bidi.script.ResultOwnership;
import org.openqa.selenium.bidi.script.SerializationOptions;

public class ChannelValue
extends LocalValue {
    private final String channelId;
    private SerializationOptions options;
    private ResultOwnership resultOwnership;

    public ChannelValue(String channelId) {
        this.channelId = channelId;
    }

    public ChannelValue(String channelId, SerializationOptions options) {
        this.channelId = channelId;
        this.options = options;
    }

    public ChannelValue(String channelId, ResultOwnership resultOwnership) {
        this.channelId = channelId;
        this.resultOwnership = resultOwnership;
    }

    ChannelValue(String channelId, SerializationOptions options, ResultOwnership resultOwnership) {
        this.channelId = channelId;
        this.options = options;
        this.resultOwnership = resultOwnership;
    }

    @Override
    public Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        TreeMap<String, Object> channelProperties = new TreeMap<String, Object>();
        channelProperties.put("channel", this.channelId);
        if (this.options != null) {
            channelProperties.put("serializationOptions", this.options);
        }
        if (this.resultOwnership != null) {
            channelProperties.put("ownership", (Object)this.resultOwnership);
        }
        toReturn.put("type", "channel");
        toReturn.put("value", channelProperties);
        return Collections.unmodifiableMap(toReturn);
    }
}

