/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chromium.ChromiumDriverLogLevel;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;

public class EdgeDriverService
extends DriverService {
    public static final String EDGE_DRIVER_NAME = "msedgedriver";
    public static final String EDGE_DRIVER_EXE_PROPERTY = "webdriver.edge.driver";
    public static final String EDGE_DRIVER_EXE_ENVIRONMENT_VARIABLE = "SE_EDGEDRIVER";
    public static final String EDGE_DRIVER_READABLE_TIMESTAMP = "webdriver.edge.readableTimestamp";
    public static final String EDGE_DRIVER_LOG_PROPERTY = "webdriver.edge.logfile";
    public static final String EDGE_DRIVER_LOG_LEVEL_PROPERTY = "webdriver.edge.loglevel";
    public static final String EDGE_DRIVER_APPEND_LOG_PROPERTY = "webdriver.edge.appendLog";
    public static final String EDGE_DRIVER_VERBOSE_LOG_PROPERTY = "webdriver.edge.verboseLogging";
    public static final String EDGE_DRIVER_SILENT_OUTPUT_PROPERTY = "webdriver.edge.silentOutput";
    public static final String EDGE_DRIVER_ALLOWED_IPS_PROPERTY = "webdriver.edge.withAllowedIps";
    public static final String EDGE_DRIVER_DISABLE_BUILD_CHECK = "webdriver.edge.disableBuildCheck";

    public EdgeDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, List.copyOf(args), Map.copyOf(environment));
    }

    @Override
    public String getDriverName() {
        return EDGE_DRIVER_NAME;
    }

    @Override
    public String getDriverProperty() {
        return EDGE_DRIVER_EXE_PROPERTY;
    }

    @Override
    public String getDriverEnvironmentVariable() {
        return EDGE_DRIVER_EXE_ENVIRONMENT_VARIABLE;
    }

    @Override
    public Capabilities getDefaultDriverOptions() {
        return new EdgeOptions();
    }

    public static EdgeDriverService createDefaultService() {
        return (EdgeDriverService)new Builder().build();
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<EdgeDriverService, Builder> {
        private Boolean disableBuildCheck;
        private Boolean readableTimestamp;
        private Boolean appendLog;
        private Boolean verbose;
        private Boolean silent;
        private String allowedListIps;
        private ChromiumDriverLogLevel logLevel;

        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.EDGE.is(capabilities)) {
                ++score;
            }
            if ("webview2".equalsIgnoreCase(capabilities.getBrowserName())) {
                ++score;
            }
            if (capabilities.getCapability("ms:edgeOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withAppendLog(boolean appendLog) {
            this.appendLog = appendLog;
            return this;
        }

        public Builder withBuildCheckDisabled(boolean noBuildCheck) {
            this.disableBuildCheck = noBuildCheck;
            return this;
        }

        public Builder withLoglevel(ChromiumDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            this.silent = false;
            this.verbose = false;
            return this;
        }

        public Builder withSilent(boolean silent) {
            if (silent) {
                this.logLevel = ChromiumDriverLogLevel.OFF;
            }
            this.silent = false;
            return this;
        }

        public Builder withVerbose(boolean verbose) {
            if (verbose) {
                this.logLevel = ChromiumDriverLogLevel.ALL;
            }
            this.verbose = false;
            return this;
        }

        public Builder withAllowedListIps(String allowedListIps) {
            this.allowedListIps = allowedListIps;
            return this;
        }

        public Builder withReadableTimestamp(Boolean readableTimestamp) {
            this.readableTimestamp = readableTimestamp;
            return this;
        }

        @Override
        protected void loadSystemProperties() {
            this.parseLogOutput(EdgeDriverService.EDGE_DRIVER_LOG_PROPERTY);
            if (this.disableBuildCheck == null) {
                this.disableBuildCheck = Boolean.getBoolean(EdgeDriverService.EDGE_DRIVER_DISABLE_BUILD_CHECK);
            }
            if (this.readableTimestamp == null) {
                this.readableTimestamp = Boolean.getBoolean(EdgeDriverService.EDGE_DRIVER_READABLE_TIMESTAMP);
            }
            if (this.appendLog == null) {
                this.appendLog = Boolean.getBoolean(EdgeDriverService.EDGE_DRIVER_APPEND_LOG_PROPERTY);
            }
            if (this.verbose == null && Boolean.getBoolean(EdgeDriverService.EDGE_DRIVER_VERBOSE_LOG_PROPERTY)) {
                this.withVerbose(Boolean.getBoolean(EdgeDriverService.EDGE_DRIVER_VERBOSE_LOG_PROPERTY));
            }
            if (this.silent == null && Boolean.getBoolean(EdgeDriverService.EDGE_DRIVER_SILENT_OUTPUT_PROPERTY)) {
                this.withSilent(Boolean.getBoolean(EdgeDriverService.EDGE_DRIVER_SILENT_OUTPUT_PROPERTY));
            }
            if (this.allowedListIps == null) {
                this.allowedListIps = System.getProperty(EdgeDriverService.EDGE_DRIVER_ALLOWED_IPS_PROPERTY);
            }
            if (this.logLevel == null && System.getProperty(EdgeDriverService.EDGE_DRIVER_LOG_LEVEL_PROPERTY) != null) {
                String level = System.getProperty(EdgeDriverService.EDGE_DRIVER_LOG_LEVEL_PROPERTY);
                this.withLoglevel(ChromiumDriverLogLevel.fromString(level));
            }
        }

        @Override
        protected List<String> createArgs() {
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format(Locale.ROOT, "--port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                args.add(String.format("--log-path=%s", this.getLogFile().getAbsolutePath()));
                if (Boolean.TRUE.equals(this.readableTimestamp)) {
                    args.add("--readable-timestamp");
                }
                if (Boolean.TRUE.equals(this.appendLog)) {
                    args.add("--append-log");
                }
                this.withLogOutput(OutputStream.nullOutputStream());
            }
            if (this.logLevel != null) {
                args.add(String.format("--log-level=%s", this.logLevel.toString().toUpperCase(Locale.ENGLISH)));
            }
            if (Boolean.TRUE.equals(this.silent)) {
                args.add("--silent");
            }
            if (Boolean.TRUE.equals(this.verbose)) {
                args.add("--verbose");
            }
            if (this.allowedListIps != null) {
                args.add(String.format("--allowed-ips=%s", this.allowedListIps));
            }
            if (Boolean.TRUE.equals(this.disableBuildCheck)) {
                args.add("--disable-build-check");
            }
            return List.copyOf(args);
        }

        @Override
        protected EdgeDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                return new EdgeDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

