/*
 * Decompiled with CFR 0.152.
 */
package graphql.relay;

import graphql.Assert;
import graphql.PublicApi;
import graphql.relay.ConnectionCursor;
import graphql.relay.Edge;
import java.util.Objects;

@PublicApi
public class DefaultEdge<T>
implements Edge<T> {
    private final T node;
    private final ConnectionCursor cursor;

    public DefaultEdge(T node, ConnectionCursor cursor) {
        this.cursor = Assert.assertNotNull(cursor, () -> "cursor cannot be null");
        this.node = node;
    }

    @Override
    public T getNode() {
        return this.node;
    }

    @Override
    public ConnectionCursor getCursor() {
        return this.cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEdge that = (DefaultEdge)o;
        return Objects.equals(this.node, that.node) && Objects.equals(this.cursor, that.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.node, this.cursor);
    }

    public String toString() {
        return "DefaultEdge{node=" + this.node + ", cursor=" + this.cursor + "}";
    }
}

