/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import org.openqa.selenium.internal.Require;

class Input {
    public static final char EOF = '\uffff';
    private static final int BUFFER_SIZE = 4096;
    private static final int MEMORY_SIZE = 128;
    private final Reader source;
    private final char[] buffer;
    private int filled;
    private int position;

    public Input(Reader source) {
        this.source = (Reader)Require.nonNull((String)"Source", (Object)source);
        this.buffer = new char[4224];
        this.filled = 0;
        this.position = -1;
    }

    public char peek() {
        return this.fill() ? this.buffer[this.position + 1] : (char)'\uffff';
    }

    public char read() {
        return this.fill() ? this.buffer[++this.position] : (char)'\uffff';
    }

    public String toString() {
        int length;
        int offset;
        if (this.position < 128) {
            offset = 0;
            length = this.position + 1;
        } else {
            offset = this.position + 1 - 128;
            length = 128;
        }
        String last = "Last " + length + " characters read: " + new String(this.buffer, offset, length);
        int next = Math.min(128, this.filled - (offset + length));
        if (next > 0) {
            if (next > 128) {
                next = 128;
            }
            return last + ", next " + next + " characters to read: " + new String(this.buffer, offset + length, next);
        }
        return last;
    }

    private boolean fill() {
        while (this.filled == this.position + 1) {
            try {
                int n;
                int shift = this.filled - 128;
                if (shift > 0) {
                    this.position -= shift;
                    this.filled -= shift;
                    System.arraycopy(this.buffer, shift, this.buffer, 0, this.filled);
                }
                if ((n = this.source.read(this.buffer, this.filled, this.buffer.length - this.filled)) == -1) {
                    return false;
                }
                this.filled += n;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
        }
        return true;
    }
}

