/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.UnixLineEndingInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnixLineEndingInputStreamTest {
    private String roundtrip(String msg) throws IOException {
        return this.roundtrip(msg, true, 0);
    }

    private String roundtrip(String msg, boolean ensureLineFeedAtEndOfFile, int minBufferLen) throws IOException {
        String string;
        Object[] buf;
        UnixLineEndingInputStream in;
        try (ByteArrayInputStream baos = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));){
            in = new UnixLineEndingInputStream((InputStream)baos, ensureLineFeedAtEndOfFile);
            try {
                buf = new byte[minBufferLen + msg.length() * 10];
                string = new String((byte[])buf, 0, in.read(buf), StandardCharsets.UTF_8);
            }
            finally {
                in.close();
            }
        }
        baos = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));
        try {
            in = new UnixLineEndingInputStream((InputStream)baos, ensureLineFeedAtEndOfFile);
            try {
                buf = new byte[minBufferLen + msg.length() * 10];
                Assertions.assertEquals((Object)string, (Object)new String((byte[])buf, 0, in.read(buf, 0, buf.length), StandardCharsets.UTF_8));
            }
            finally {
                in.close();
            }
        }
        finally {
            baos.close();
        }
        baos = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));
        try {
            in = new UnixLineEndingInputStream((InputStream)baos, ensureLineFeedAtEndOfFile);
            try {
                buf = new int[minBufferLen + msg.length() * 10];
                if (buf.length > 0) {
                    int b;
                    int i = 0;
                    while ((b = in.read()) != -1) {
                        buf[i++] = b;
                    }
                    Assertions.assertEquals((Object)string, (Object)new String((int[])buf, 0, i));
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            baos.close();
        }
        return string;
    }

    @Test
    public void testCrAtEnd() throws Exception {
        Assertions.assertEquals((Object)"a\n", (Object)this.roundtrip("a\r"));
    }

    @Test
    public void testCrOnlyEnsureAtEof() throws Exception {
        Assertions.assertEquals((Object)"a\nb\n", (Object)this.roundtrip("a\rb"));
    }

    @Test
    public void testCrOnlyNotAtEof() throws Exception {
        Assertions.assertEquals((Object)"a\nb", (Object)this.roundtrip("a\rb", false, 0));
    }

    @Test
    public void testEmpty() throws Exception {
        Assertions.assertEquals((Object)"", (Object)this.roundtrip(""));
    }

    @Test
    public void testInTheMiddleOfTheLine() throws Exception {
        Assertions.assertEquals((Object)"a\nbc\n", (Object)this.roundtrip("a\r\nbc"));
    }

    @Test
    public void testMultipleBlankLines() throws Exception {
        Assertions.assertEquals((Object)"a\n\nbc\n", (Object)this.roundtrip("a\r\n\r\nbc"));
    }

    @Test
    public void testRetainLineFeed() throws Exception {
        Assertions.assertEquals((Object)"a\n\n", (Object)this.roundtrip("a\r\n\r\n", false, 0));
        Assertions.assertEquals((Object)"a", (Object)this.roundtrip("a", false, 0));
    }

    @Test
    public void testSimpleString() throws Exception {
        Assertions.assertEquals((Object)"abc\n", (Object)this.roundtrip("abc"));
    }

    @Test
    public void testTwoLinesAtEnd() throws Exception {
        Assertions.assertEquals((Object)"a\n\n", (Object)this.roundtrip("a\r\n\r\n"));
    }
}

