/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import org.apache.commons.io.FileSystem;
import org.apache.commons.io.filefilter.AbstractFilterTest;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PathMatcherFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathMatcherFileFilterTest
extends AbstractFilterTest {
    @Test
    public void testGlob() throws IOException {
        PathMatcherFileFilter filter = new PathMatcherFileFilter(FileSystems.getDefault().getPathMatcher("glob:*.txt"));
        File file1 = new File("log.txt");
        File file2 = new File("log.TXT");
        Assertions.assertTrue((boolean)filter.accept(file1));
        Assertions.assertEquals((Object)(!FileSystem.getCurrent().isCaseSensitive() ? 1 : 0), (Object)filter.accept(file2));
        Assertions.assertTrue((boolean)filter.accept(file1.getParentFile(), file1.getName()));
        Assertions.assertEquals((Object)(!FileSystem.getCurrent().isCaseSensitive() ? 1 : 0), (Object)filter.accept(file2.getParentFile(), file2.getName()));
        this.assertFiltering((IOFileFilter)filter, file1, true);
        this.assertFiltering((IOFileFilter)filter, file1.toPath(), true);
    }
}

