/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.io.ThreadUtils;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.PathVisitor;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.EmptyFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PathVisitorFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class AccumulatorPathVisitorTest {
    @TempDir
    Path tempDirPath;

    static Stream<Arguments> testParameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{AccumulatorPathVisitor::withLongCounters}), Arguments.of((Object[])new Object[]{AccumulatorPathVisitor::withBigIntegerCounters}), Arguments.of((Object[])new Object[]{() -> AccumulatorPathVisitor.withBigIntegerCounters((PathFilter)TrueFileFilter.INSTANCE, (PathFilter)TrueFileFilter.INSTANCE)}));
    }

    static Stream<Arguments> testParametersIgnoreFailures() {
        return Stream.of(Arguments.of((Object[])new Object[]{() -> new AccumulatorPathVisitor(Counters.bigIntegerPathCounters(), (PathFilter)CountingPathVisitor.defaultDirectoryFilter(), (PathFilter)CountingPathVisitor.defaultFileFilter())}));
    }

    @Test
    public void test0ArgConstructor() throws IOException {
        AccumulatorPathVisitor accPathVisitor = new AccumulatorPathVisitor();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)accPathVisitor);
        Files.walkFileTree(this.tempDirPath, (FileVisitor<? super Path>)new AndFileFilter(new IOFileFilter[]{countingFileFilter, DirectoryFileFilter.INSTANCE, EmptyFileFilter.EMPTY}));
        CounterAssertions.assertCounts(0L, 0L, 0L, accPathVisitor.getPathCounters());
        Assertions.assertEquals((int)1, (int)accPathVisitor.getDirList().size());
        Assertions.assertTrue((boolean)accPathVisitor.getFileList().isEmpty());
        Assertions.assertEquals((Object)accPathVisitor, (Object)accPathVisitor);
        Assertions.assertEquals((int)accPathVisitor.hashCode(), (int)accPathVisitor.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"testParameters"})
    public void testEmptyFolder(Supplier<AccumulatorPathVisitor> supplier) throws IOException {
        AccumulatorPathVisitor accPathVisitor = supplier.get();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)accPathVisitor);
        Files.walkFileTree(this.tempDirPath, (FileVisitor<? super Path>)new AndFileFilter(new IOFileFilter[]{countingFileFilter, DirectoryFileFilter.INSTANCE, EmptyFileFilter.EMPTY}));
        CounterAssertions.assertCounts(1L, 0L, 0L, accPathVisitor.getPathCounters());
        Assertions.assertEquals((int)1, (int)accPathVisitor.getDirList().size());
        Assertions.assertTrue((boolean)accPathVisitor.getFileList().isEmpty());
        Assertions.assertEquals((Object)accPathVisitor, (Object)accPathVisitor);
        Assertions.assertEquals((int)accPathVisitor.hashCode(), (int)accPathVisitor.hashCode());
    }

    @Test
    public void testEqualsHashCode() {
        AccumulatorPathVisitor visitor0 = AccumulatorPathVisitor.withLongCounters();
        AccumulatorPathVisitor visitor1 = AccumulatorPathVisitor.withLongCounters();
        Assertions.assertEquals((Object)visitor0, (Object)visitor0);
        Assertions.assertEquals((Object)visitor0, (Object)visitor1);
        Assertions.assertEquals((Object)visitor1, (Object)visitor0);
        Assertions.assertEquals((int)visitor0.hashCode(), (int)visitor0.hashCode());
        Assertions.assertEquals((int)visitor0.hashCode(), (int)visitor1.hashCode());
        Assertions.assertEquals((int)visitor1.hashCode(), (int)visitor0.hashCode());
        visitor0.getPathCounters().getByteCounter().increment();
        Assertions.assertEquals((Object)visitor0, (Object)visitor0);
        Assertions.assertNotEquals((Object)visitor0, (Object)visitor1);
        Assertions.assertNotEquals((Object)visitor1, (Object)visitor0);
        Assertions.assertEquals((int)visitor0.hashCode(), (int)visitor0.hashCode());
        Assertions.assertNotEquals((int)visitor0.hashCode(), (int)visitor1.hashCode());
        Assertions.assertNotEquals((int)visitor1.hashCode(), (int)visitor0.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"testParameters"})
    public void testFolders1FileSize0(Supplier<AccumulatorPathVisitor> supplier) throws IOException {
        AccumulatorPathVisitor accPathVisitor = supplier.get();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)accPathVisitor);
        Files.walkFileTree(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]), (FileVisitor<? super Path>)countingFileFilter);
        CounterAssertions.assertCounts(1L, 1L, 0L, accPathVisitor.getPathCounters());
        Assertions.assertEquals((int)1, (int)accPathVisitor.getDirList().size());
        Assertions.assertEquals((int)1, (int)accPathVisitor.getFileList().size());
        Assertions.assertEquals((Object)accPathVisitor, (Object)accPathVisitor);
        Assertions.assertEquals((int)accPathVisitor.hashCode(), (int)accPathVisitor.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"testParameters"})
    public void testFolders1FileSize1(Supplier<AccumulatorPathVisitor> supplier) throws IOException {
        AccumulatorPathVisitor accPathVisitor = supplier.get();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)accPathVisitor);
        Files.walkFileTree(Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]), (FileVisitor<? super Path>)countingFileFilter);
        CounterAssertions.assertCounts(1L, 1L, 1L, accPathVisitor.getPathCounters());
        Assertions.assertEquals((int)1, (int)accPathVisitor.getDirList().size());
        Assertions.assertEquals((int)1, (int)accPathVisitor.getFileList().size());
        Assertions.assertEquals((Object)accPathVisitor, (Object)accPathVisitor);
        Assertions.assertEquals((int)accPathVisitor.hashCode(), (int)accPathVisitor.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"testParameters"})
    public void testFolders2FileSize2(Supplier<AccumulatorPathVisitor> supplier) throws IOException {
        AccumulatorPathVisitor accPathVisitor = supplier.get();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)accPathVisitor);
        Files.walkFileTree(Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]), (FileVisitor<? super Path>)countingFileFilter);
        CounterAssertions.assertCounts(3L, 2L, 2L, accPathVisitor.getPathCounters());
        Assertions.assertEquals((int)3, (int)accPathVisitor.getDirList().size());
        Assertions.assertEquals((int)2, (int)accPathVisitor.getFileList().size());
        Assertions.assertEquals((Object)accPathVisitor, (Object)accPathVisitor);
        Assertions.assertEquals((int)accPathVisitor.hashCode(), (int)accPathVisitor.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"testParametersIgnoreFailures"})
    public void testFolderWhileDeletingAsync(Supplier<AccumulatorPathVisitor> supplier) throws IOException, InterruptedException {
        int count = 10000;
        ArrayList<Path> files = new ArrayList<Path>(10000);
        for (int i = 1; i <= 10000; ++i) {
            Path tempFile = Files.createTempFile(this.tempDirPath, "test", ".txt", new FileAttribute[0]);
            Assertions.assertTrue((boolean)Files.exists(tempFile, new LinkOption[0]));
            files.add(tempFile);
        }
        AccumulatorPathVisitor accPathVisitor = supplier.get();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)accPathVisitor){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) throws IOException {
                try {
                    ThreadUtils.sleep((Duration)Duration.ofMillis(10L));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return super.visitFile(path, attributes);
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AtomicBoolean deleted = new AtomicBoolean();
        try {
            executor.execute(() -> {
                for (Path file : files) {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException iOException) {}
                }
                deleted.set(true);
            });
            Files.walkFileTree(this.tempDirPath, (FileVisitor<? super Path>)countingFileFilter);
        }
        finally {
            if (!deleted.get()) {
                ThreadUtils.sleep((Duration)Duration.ofMillis(1000L));
            }
            if (!deleted.get()) {
                executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            executor.shutdownNow();
        }
        Assertions.assertEquals((Object)accPathVisitor, (Object)accPathVisitor);
        Assertions.assertEquals((int)accPathVisitor.hashCode(), (int)accPathVisitor.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"testParametersIgnoreFailures"})
    public void testFolderWhileDeletingSync(Supplier<AccumulatorPathVisitor> supplier) throws IOException {
        int count = 100;
        int marker = 50;
        final LinkedHashSet<Path> files = new LinkedHashSet<Path>(100);
        for (int i = 1; i <= 100; ++i) {
            Path tempFile = Files.createTempFile(this.tempDirPath, "test", ".txt", new FileAttribute[0]);
            Assertions.assertTrue((boolean)Files.exists(tempFile, new LinkOption[0]));
            files.add(tempFile);
        }
        AccumulatorPathVisitor accPathVisitor = supplier.get();
        final AtomicInteger visitCount = new AtomicInteger();
        PathVisitorFileFilter countingFileFilter = new PathVisitorFileFilter((PathVisitor)accPathVisitor){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) throws IOException {
                if (visitCount.incrementAndGet() == 50) {
                    for (Path file : files) {
                        Files.delete(file);
                    }
                }
                return super.visitFile(path, attributes);
            }
        };
        Files.walkFileTree(this.tempDirPath, (FileVisitor<? super Path>)countingFileFilter);
        CounterAssertions.assertCounts(1L, 49L, 0L, accPathVisitor.getPathCounters());
        Assertions.assertEquals((int)1, (int)accPathVisitor.getDirList().size());
        Assertions.assertEquals((int)49, (int)accPathVisitor.getFileList().size());
        Assertions.assertEquals((Object)accPathVisitor, (Object)accPathVisitor);
        Assertions.assertEquals((int)accPathVisitor.hashCode(), (int)accPathVisitor.hashCode());
    }
}

