/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.nio.ByteOrder;
import org.apache.commons.io.ByteOrderParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ByteOrderParserTest {
    private ByteOrder parseByteOrder(String value) {
        return ByteOrderParser.parseByteOrder((String)value);
    }

    @Test
    public void testParseBig() {
        Assertions.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)this.parseByteOrder("BIG_ENDIAN"));
    }

    @Test
    public void testParseLittle() {
        Assertions.assertEquals((Object)ByteOrder.LITTLE_ENDIAN, (Object)this.parseByteOrder("LITTLE_ENDIAN"));
    }

    @Test
    public void testThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.parseByteOrder("some value"));
    }
}

